/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.internals.HasNextCondition;
import org.apache.kafka.streams.state.internals.KeyValueSegment;
import org.apache.kafka.streams.state.internals.SegmentIterator;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.streams.state.internals.metrics.RocksDBMetricsRecorder;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.MockRecordCollector;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SegmentIteratorTest {
    private final RocksDBMetricsRecorder rocksDBMetricsRecorder = new RocksDBMetricsRecorder("metrics-scope", "store-name");
    private final KeyValueSegment segmentOne = new KeyValueSegment("one", "one", 0L, this.rocksDBMetricsRecorder);
    private final KeyValueSegment segmentTwo = new KeyValueSegment("two", "window", 1L, this.rocksDBMetricsRecorder);
    private final HasNextCondition hasNextCondition = Iterator::hasNext;
    private SegmentIterator<KeyValueSegment> iterator = null;

    @Before
    public void before() {
        InternalMockProcessorContext context = new InternalMockProcessorContext(TestUtils.tempDirectory(), Serdes.String(), Serdes.String(), new MockRecordCollector(), new ThreadCache(new LogContext("testCache "), 0L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics())));
        this.segmentOne.init((StateStoreContext)context, (StateStore)this.segmentOne);
        this.segmentTwo.init((StateStoreContext)context, (StateStore)this.segmentTwo);
        this.segmentOne.put(Bytes.wrap((byte[])"a".getBytes()), "1".getBytes());
        this.segmentOne.put(Bytes.wrap((byte[])"b".getBytes()), "2".getBytes());
        this.segmentTwo.put(Bytes.wrap((byte[])"c".getBytes()), "3".getBytes());
        this.segmentTwo.put(Bytes.wrap((byte[])"d".getBytes()), "4".getBytes());
    }

    @After
    public void closeSegments() {
        if (this.iterator != null) {
            this.iterator.close();
            this.iterator = null;
        }
        this.segmentOne.close();
        this.segmentTwo.close();
    }

    @Test
    public void shouldIterateOverAllSegments() {
        this.iterator = new SegmentIterator(Arrays.asList(this.segmentOne, this.segmentTwo).iterator(), this.hasNextCondition, Bytes.wrap((byte[])"a".getBytes()), Bytes.wrap((byte[])"z".getBytes()), true);
        Assert.assertTrue((boolean)this.iterator.hasNext());
        Assert.assertEquals((Object)"a", (Object)new String(this.iterator.peekNextKey().get()));
        Assert.assertEquals((Object)KeyValue.pair((Object)"a", (Object)"1"), this.toStringKeyValue((KeyValue<Bytes, byte[]>)this.iterator.next()));
        Assert.assertTrue((boolean)this.iterator.hasNext());
        Assert.assertEquals((Object)"b", (Object)new String(this.iterator.peekNextKey().get()));
        Assert.assertEquals((Object)KeyValue.pair((Object)"b", (Object)"2"), this.toStringKeyValue((KeyValue<Bytes, byte[]>)this.iterator.next()));
        Assert.assertTrue((boolean)this.iterator.hasNext());
        Assert.assertEquals((Object)"c", (Object)new String(this.iterator.peekNextKey().get()));
        Assert.assertEquals((Object)KeyValue.pair((Object)"c", (Object)"3"), this.toStringKeyValue((KeyValue<Bytes, byte[]>)this.iterator.next()));
        Assert.assertTrue((boolean)this.iterator.hasNext());
        Assert.assertEquals((Object)"d", (Object)new String(this.iterator.peekNextKey().get()));
        Assert.assertEquals((Object)KeyValue.pair((Object)"d", (Object)"4"), this.toStringKeyValue((KeyValue<Bytes, byte[]>)this.iterator.next()));
        Assert.assertFalse((boolean)this.iterator.hasNext());
    }

    @Test
    public void shouldIterateBackwardOverAllSegments() {
        this.iterator = new SegmentIterator(Arrays.asList(this.segmentTwo, this.segmentOne).iterator(), this.hasNextCondition, Bytes.wrap((byte[])"a".getBytes()), Bytes.wrap((byte[])"z".getBytes()), false);
        Assert.assertTrue((boolean)this.iterator.hasNext());
        Assert.assertEquals((Object)"d", (Object)new String(this.iterator.peekNextKey().get()));
        Assert.assertEquals((Object)KeyValue.pair((Object)"d", (Object)"4"), this.toStringKeyValue((KeyValue<Bytes, byte[]>)this.iterator.next()));
        Assert.assertTrue((boolean)this.iterator.hasNext());
        Assert.assertEquals((Object)"c", (Object)new String(this.iterator.peekNextKey().get()));
        Assert.assertEquals((Object)KeyValue.pair((Object)"c", (Object)"3"), this.toStringKeyValue((KeyValue<Bytes, byte[]>)this.iterator.next()));
        Assert.assertTrue((boolean)this.iterator.hasNext());
        Assert.assertEquals((Object)"b", (Object)new String(this.iterator.peekNextKey().get()));
        Assert.assertEquals((Object)KeyValue.pair((Object)"b", (Object)"2"), this.toStringKeyValue((KeyValue<Bytes, byte[]>)this.iterator.next()));
        Assert.assertTrue((boolean)this.iterator.hasNext());
        Assert.assertEquals((Object)"a", (Object)new String(this.iterator.peekNextKey().get()));
        Assert.assertEquals((Object)KeyValue.pair((Object)"a", (Object)"1"), this.toStringKeyValue((KeyValue<Bytes, byte[]>)this.iterator.next()));
        Assert.assertFalse((boolean)this.iterator.hasNext());
    }

    @Test
    public void shouldNotThrowExceptionOnHasNextWhenStoreClosed() {
        this.iterator = new SegmentIterator(Collections.singletonList(this.segmentOne).iterator(), this.hasNextCondition, Bytes.wrap((byte[])"a".getBytes()), Bytes.wrap((byte[])"z".getBytes()), true);
        this.iterator.currentIterator = this.segmentOne.all();
        this.segmentOne.close();
        Assert.assertFalse((boolean)this.iterator.hasNext());
    }

    @Test
    public void shouldOnlyIterateOverSegmentsInBackwardRange() {
        this.iterator = new SegmentIterator(Arrays.asList(this.segmentOne, this.segmentTwo).iterator(), this.hasNextCondition, Bytes.wrap((byte[])"a".getBytes()), Bytes.wrap((byte[])"b".getBytes()), false);
        Assert.assertTrue((boolean)this.iterator.hasNext());
        Assert.assertEquals((Object)"b", (Object)new String(this.iterator.peekNextKey().get()));
        Assert.assertEquals((Object)KeyValue.pair((Object)"b", (Object)"2"), this.toStringKeyValue((KeyValue<Bytes, byte[]>)this.iterator.next()));
        Assert.assertTrue((boolean)this.iterator.hasNext());
        Assert.assertEquals((Object)"a", (Object)new String(this.iterator.peekNextKey().get()));
        Assert.assertEquals((Object)KeyValue.pair((Object)"a", (Object)"1"), this.toStringKeyValue((KeyValue<Bytes, byte[]>)this.iterator.next()));
        Assert.assertFalse((boolean)this.iterator.hasNext());
    }

    @Test
    public void shouldOnlyIterateOverSegmentsInRange() {
        this.iterator = new SegmentIterator(Arrays.asList(this.segmentOne, this.segmentTwo).iterator(), this.hasNextCondition, Bytes.wrap((byte[])"a".getBytes()), Bytes.wrap((byte[])"b".getBytes()), true);
        Assert.assertTrue((boolean)this.iterator.hasNext());
        Assert.assertEquals((Object)"a", (Object)new String(this.iterator.peekNextKey().get()));
        Assert.assertEquals((Object)KeyValue.pair((Object)"a", (Object)"1"), this.toStringKeyValue((KeyValue<Bytes, byte[]>)this.iterator.next()));
        Assert.assertTrue((boolean)this.iterator.hasNext());
        Assert.assertEquals((Object)"b", (Object)new String(this.iterator.peekNextKey().get()));
        Assert.assertEquals((Object)KeyValue.pair((Object)"b", (Object)"2"), this.toStringKeyValue((KeyValue<Bytes, byte[]>)this.iterator.next()));
        Assert.assertFalse((boolean)this.iterator.hasNext());
    }

    @Test
    public void shouldThrowNoSuchElementOnPeekNextKeyIfNoNext() {
        this.iterator = new SegmentIterator(Arrays.asList(this.segmentOne, this.segmentTwo).iterator(), this.hasNextCondition, Bytes.wrap((byte[])"f".getBytes()), Bytes.wrap((byte[])"h".getBytes()), true);
        Assert.assertThrows(NoSuchElementException.class, () -> this.iterator.peekNextKey());
    }

    @Test
    public void shouldThrowNoSuchElementOnNextIfNoNext() {
        this.iterator = new SegmentIterator(Arrays.asList(this.segmentOne, this.segmentTwo).iterator(), this.hasNextCondition, Bytes.wrap((byte[])"f".getBytes()), Bytes.wrap((byte[])"h".getBytes()), true);
        Assert.assertThrows(NoSuchElementException.class, () -> this.iterator.next());
    }

    private KeyValue<String, String> toStringKeyValue(KeyValue<Bytes, byte[]> binaryKv) {
        return KeyValue.pair((Object)new String(((Bytes)binaryKv.key).get()), (Object)new String((byte[])binaryKv.value));
    }
}

