/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.internals.ReadOnlyKeyValueStoreFacade;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class ReadOnlyKeyValueStoreFacadeTest {
    @Mock
    private TimestampedKeyValueStore<String, String> mockedKeyValueTimestampStore;
    @Mock
    private KeyValueIterator<String, ValueAndTimestamp<String>> mockedKeyValueTimestampIterator;
    private ReadOnlyKeyValueStoreFacade<String, String> readOnlyKeyValueStoreFacade;

    @Before
    public void setup() {
        this.readOnlyKeyValueStoreFacade = new ReadOnlyKeyValueStoreFacade(this.mockedKeyValueTimestampStore);
    }

    @Test
    public void shouldReturnPlainValueOnGet() {
        EasyMock.expect((Object)this.mockedKeyValueTimestampStore.get((Object)"key")).andReturn((Object)ValueAndTimestamp.make((Object)"value", (long)42L));
        EasyMock.expect((Object)this.mockedKeyValueTimestampStore.get((Object)"unknownKey")).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.mockedKeyValueTimestampStore});
        MatcherAssert.assertThat((Object)this.readOnlyKeyValueStoreFacade.get((Object)"key"), (Matcher)Matchers.is((Object)"value"));
        Assert.assertNull((Object)this.readOnlyKeyValueStoreFacade.get((Object)"unknownKey"));
        EasyMock.verify((Object[])new Object[]{this.mockedKeyValueTimestampStore});
    }

    @Test
    public void shouldReturnPlainKeyValuePairsForRangeIterator() {
        EasyMock.expect((Object)this.mockedKeyValueTimestampIterator.next()).andReturn((Object)KeyValue.pair((Object)"key1", (Object)ValueAndTimestamp.make((Object)"value1", (long)21L))).andReturn((Object)KeyValue.pair((Object)"key2", (Object)ValueAndTimestamp.make((Object)"value2", (long)42L)));
        EasyMock.expect((Object)this.mockedKeyValueTimestampStore.range((Object)"key1", (Object)"key2")).andReturn(this.mockedKeyValueTimestampIterator);
        EasyMock.replay((Object[])new Object[]{this.mockedKeyValueTimestampIterator, this.mockedKeyValueTimestampStore});
        KeyValueIterator iterator = this.readOnlyKeyValueStoreFacade.range((Object)"key1", (Object)"key2");
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)"key1", (Object)"value1")));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)"key2", (Object)"value2")));
        EasyMock.verify((Object[])new Object[]{this.mockedKeyValueTimestampIterator, this.mockedKeyValueTimestampStore});
    }

    @Test
    public void shouldReturnPlainKeyValuePairsForAllIterator() {
        EasyMock.expect((Object)this.mockedKeyValueTimestampIterator.next()).andReturn((Object)KeyValue.pair((Object)"key1", (Object)ValueAndTimestamp.make((Object)"value1", (long)21L))).andReturn((Object)KeyValue.pair((Object)"key2", (Object)ValueAndTimestamp.make((Object)"value2", (long)42L)));
        EasyMock.expect((Object)this.mockedKeyValueTimestampStore.all()).andReturn(this.mockedKeyValueTimestampIterator);
        EasyMock.replay((Object[])new Object[]{this.mockedKeyValueTimestampIterator, this.mockedKeyValueTimestampStore});
        KeyValueIterator iterator = this.readOnlyKeyValueStoreFacade.all();
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)"key1", (Object)"value1")));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)"key2", (Object)"value2")));
        EasyMock.verify((Object[])new Object[]{this.mockedKeyValueTimestampIterator, this.mockedKeyValueTimestampStore});
    }

    @Test
    public void shouldForwardApproximateNumEntries() {
        EasyMock.expect((Object)this.mockedKeyValueTimestampStore.approximateNumEntries()).andReturn((Object)42L);
        EasyMock.replay((Object[])new Object[]{this.mockedKeyValueTimestampStore});
        MatcherAssert.assertThat((Object)this.readOnlyKeyValueStoreFacade.approximateNumEntries(), (Matcher)Matchers.is((Object)42L));
        EasyMock.verify((Object[])new Object[]{this.mockedKeyValueTimestampStore});
    }
}

