/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StoreQueryParameters;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.QueryableStoreTypes;
import org.apache.kafka.streams.state.internals.CompositeReadOnlySessionStore;
import org.apache.kafka.streams.state.internals.StateStoreProvider;
import org.apache.kafka.streams.state.internals.StreamThreadStateStoreProvider;
import org.apache.kafka.streams.state.internals.WrappingStoreProvider;
import org.apache.kafka.test.ReadOnlySessionStoreStub;
import org.apache.kafka.test.StateStoreProviderStub;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompositeReadOnlySessionStoreTest {
    private final String storeName = "session-store";
    private final StateStoreProviderStub stubProviderOne = new StateStoreProviderStub(false);
    private final StateStoreProviderStub stubProviderTwo = new StateStoreProviderStub(false);
    private final ReadOnlySessionStoreStub<String, Long> underlyingSessionStore = new ReadOnlySessionStoreStub();
    private final ReadOnlySessionStoreStub<String, Long> otherUnderlyingStore = new ReadOnlySessionStoreStub();
    private CompositeReadOnlySessionStore<String, Long> sessionStore;

    @Before
    public void before() {
        this.stubProviderOne.addStore("session-store", this.underlyingSessionStore);
        this.stubProviderOne.addStore("other-session-store", this.otherUnderlyingStore);
        QueryableStoreType queryableStoreType = QueryableStoreTypes.sessionStore();
        this.sessionStore = new CompositeReadOnlySessionStore((StateStoreProvider)new WrappingStoreProvider(Arrays.asList(new StreamThreadStateStoreProvider[]{this.stubProviderOne, this.stubProviderTwo}), StoreQueryParameters.fromNameAndType((String)"session-store", (QueryableStoreType)queryableStoreType)), QueryableStoreTypes.sessionStore(), "session-store");
    }

    @Test
    public void shouldFetchResulstFromUnderlyingSessionStore() {
        this.underlyingSessionStore.put((Windowed<String>)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), 1L);
        this.underlyingSessionStore.put((Windowed<String>)new Windowed((Object)"a", (Window)new SessionWindow(10L, 10L)), 2L);
        List results = StreamsTestUtils.toList(this.sessionStore.fetch((Object)"a"));
        Assert.assertEquals(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L), KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(10L, 10L)), (Object)2L)), results);
    }

    @Test
    public void shouldReturnEmptyIteratorIfNoData() {
        KeyValueIterator result = this.sessionStore.fetch((Object)"b");
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void shouldFindValueForKeyWhenMultiStores() {
        ReadOnlySessionStoreStub secondUnderlying = new ReadOnlySessionStoreStub();
        this.stubProviderTwo.addStore("session-store", secondUnderlying);
        Windowed keyOne = new Windowed((Object)"key-one", (Window)new SessionWindow(0L, 0L));
        Windowed keyTwo = new Windowed((Object)"key-two", (Window)new SessionWindow(0L, 0L));
        this.underlyingSessionStore.put((Windowed<String>)keyOne, 0L);
        secondUnderlying.put(keyTwo, 10L);
        List keyOneResults = StreamsTestUtils.toList(this.sessionStore.fetch((Object)"key-one"));
        List keyTwoResults = StreamsTestUtils.toList(this.sessionStore.fetch((Object)"key-two"));
        Assert.assertEquals(Collections.singletonList(KeyValue.pair((Object)keyOne, (Object)0L)), keyOneResults);
        Assert.assertEquals(Collections.singletonList(KeyValue.pair((Object)keyTwo, (Object)10L)), keyTwoResults);
    }

    @Test
    public void shouldNotGetValueFromOtherStores() {
        Windowed expectedKey = new Windowed((Object)"foo", (Window)new SessionWindow(0L, 0L));
        this.otherUnderlyingStore.put((Windowed<String>)new Windowed((Object)"foo", (Window)new SessionWindow(10L, 10L)), 10L);
        this.underlyingSessionStore.put((Windowed<String>)expectedKey, 1L);
        KeyValueIterator result = this.sessionStore.fetch((Object)"foo");
        Assert.assertEquals((Object)KeyValue.pair((Object)expectedKey, (Object)1L), (Object)result.next());
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void shouldThrowInvalidStateStoreExceptionOnRebalance() {
        QueryableStoreType queryableStoreType = QueryableStoreTypes.sessionStore();
        CompositeReadOnlySessionStore store = new CompositeReadOnlySessionStore((StateStoreProvider)new WrappingStoreProvider(Collections.singletonList(new StateStoreProviderStub(true)), StoreQueryParameters.fromNameAndType((String)"whateva", (QueryableStoreType)queryableStoreType)), QueryableStoreTypes.sessionStore(), "whateva");
        Assert.assertThrows(InvalidStateStoreException.class, () -> store.fetch((Object)"a"));
    }

    @Test
    public void shouldThrowInvalidStateStoreExceptionIfSessionFetchThrows() {
        this.underlyingSessionStore.setOpen(false);
        try {
            this.sessionStore.fetch((Object)"key");
            Assert.fail((String)"Should have thrown InvalidStateStoreException with session store");
        }
        catch (InvalidStateStoreException invalidStateStoreException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowNullPointerExceptionIfFetchingNullKey() {
        Assert.assertThrows(NullPointerException.class, () -> this.sessionStore.fetch(null));
    }

    @Test
    public void shouldFetchKeyRangeAcrossStores() {
        ReadOnlySessionStoreStub secondUnderlying = new ReadOnlySessionStoreStub();
        this.stubProviderTwo.addStore("session-store", secondUnderlying);
        this.underlyingSessionStore.put((Windowed<String>)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), 0L);
        secondUnderlying.put(new Windowed((Object)"b", (Window)new SessionWindow(0L, 0L)), 10L);
        List results = StreamsTestUtils.toList(this.sessionStore.fetch((Object)"a", (Object)"b"));
        MatcherAssert.assertThat((Object)results.size(), (Matcher)IsEqual.equalTo((Object)2));
    }

    @Test
    public void shouldThrowNPEIfKeyIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.underlyingSessionStore.fetch(null));
    }

    @Test
    public void shouldThrowNPEIfFromKeyIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.underlyingSessionStore.fetch(null, "a"));
    }

    @Test
    public void shouldThrowNPEIfToKeyIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.underlyingSessionStore.fetch("a", null));
    }
}

