/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.internals.AbstractKeyValueStoreTest;
import org.apache.kafka.streams.state.internals.CacheFlushListenerStub;
import org.apache.kafka.streams.state.internals.CachingKeyValueStore;
import org.apache.kafka.streams.state.internals.InMemoryKeyValueStore;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.streams.state.internals.ThreadCacheTest;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.TestUtils;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CachingInMemoryKeyValueStoreTest
extends AbstractKeyValueStoreTest {
    private static final String TOPIC = "topic";
    private static final String CACHE_NAMESPACE = "0_0-store-name";
    private final int maxCacheSizeBytes = 150;
    private InternalMockProcessorContext context;
    private CachingKeyValueStore store;
    private KeyValueStore<Bytes, byte[]> underlyingStore;
    private ThreadCache cache;
    private CacheFlushListenerStub<String, String> cacheFlushListener;

    @Before
    public void setUp() {
        String storeName = "store";
        this.underlyingStore = new InMemoryKeyValueStore("store");
        this.cacheFlushListener = new CacheFlushListenerStub(new StringDeserializer(), new StringDeserializer());
        this.store = new CachingKeyValueStore(this.underlyingStore);
        this.store.setFlushListener(this.cacheFlushListener, false);
        this.cache = new ThreadCache(new LogContext("testCache "), 150L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics()));
        this.context = new InternalMockProcessorContext(null, null, null, null, this.cache);
        this.context.setRecordContext(new ProcessorRecordContext(10L, 0L, 0, TOPIC, null));
        this.store.init((StateStoreContext)this.context, null);
    }

    @Override
    @After
    public void after() {
        super.after();
    }

    @Override
    protected <K, V> KeyValueStore<K, V> createKeyValueStore(StateStoreContext context) {
        StoreBuilder storeBuilder = Stores.keyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.persistentKeyValueStore((String)"cache-store"), (Serde)context.keySerde(), (Serde)context.valueSerde()).withCachingEnabled();
        KeyValueStore store = (KeyValueStore)storeBuilder.build();
        store.init(context, (StateStore)store);
        return store;
    }

    @Test
    public void shouldDelegateDeprecatedInit() {
        KeyValueStore inner = (KeyValueStore)EasyMock.mock(InMemoryKeyValueStore.class);
        CachingKeyValueStore outer = new CachingKeyValueStore(inner);
        EasyMock.expect((Object)inner.name()).andStubReturn((Object)"store");
        inner.init((ProcessorContext)this.context, (StateStore)outer);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{inner});
        outer.init((ProcessorContext)this.context, (StateStore)outer);
        EasyMock.verify((Object[])new Object[]{inner});
    }

    @Test
    public void shouldDelegateInit() {
        KeyValueStore inner = (KeyValueStore)EasyMock.mock(InMemoryKeyValueStore.class);
        CachingKeyValueStore outer = new CachingKeyValueStore(inner);
        EasyMock.expect((Object)inner.name()).andStubReturn((Object)"store");
        inner.init((StateStoreContext)this.context, (StateStore)outer);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{inner});
        outer.init((StateStoreContext)this.context, (StateStore)outer);
        EasyMock.verify((Object[])new Object[]{inner});
    }

    @Test
    public void shouldSetFlushListener() {
        Assert.assertTrue((boolean)this.store.setFlushListener(null, true));
        Assert.assertTrue((boolean)this.store.setFlushListener(null, false));
    }

    @Test
    public void shouldAvoidFlushingDeletionsWithoutDirtyKeys() {
        int added = this.addItemsToCache();
        Assert.assertEquals((long)added, (long)this.underlyingStore.approximateNumEntries());
        Assert.assertEquals((long)added, (long)this.cacheFlushListener.forwarded.size());
        this.store.put(this.bytesKey("key"), this.bytesValue("value"));
        Assert.assertEquals((long)added, (long)this.underlyingStore.approximateNumEntries());
        Assert.assertEquals((long)added, (long)this.cacheFlushListener.forwarded.size());
        this.store.put(this.bytesKey("key"), null);
        this.store.flush();
        Assert.assertEquals((long)added, (long)this.underlyingStore.approximateNumEntries());
        Assert.assertEquals((long)added, (long)this.cacheFlushListener.forwarded.size());
    }

    @Test
    public void shouldCloseWrappedStoreAndCacheAfterErrorDuringCacheFlush() {
        this.setUpCloseTests();
        EasyMock.reset((Object[])new Object[]{this.cache});
        this.cache.flush(CACHE_NAMESPACE);
        EasyMock.expectLastCall().andThrow((Throwable)new RuntimeException("Simulating an error on flush"));
        EasyMock.replay((Object[])new Object[]{this.cache});
        EasyMock.reset((Object[])new Object[]{this.underlyingStore});
        this.underlyingStore.close();
        EasyMock.replay((Object[])new Object[]{this.underlyingStore});
        Assert.assertThrows(RuntimeException.class, () -> ((CachingKeyValueStore)this.store).close());
        EasyMock.verify((Object[])new Object[]{this.cache, this.underlyingStore});
    }

    @Test
    public void shouldCloseWrappedStoreAfterErrorDuringCacheClose() {
        this.setUpCloseTests();
        EasyMock.reset((Object[])new Object[]{this.cache});
        this.cache.flush(CACHE_NAMESPACE);
        this.cache.close(CACHE_NAMESPACE);
        EasyMock.expectLastCall().andThrow((Throwable)new RuntimeException("Simulating an error on close"));
        EasyMock.replay((Object[])new Object[]{this.cache});
        EasyMock.reset((Object[])new Object[]{this.underlyingStore});
        this.underlyingStore.close();
        EasyMock.replay((Object[])new Object[]{this.underlyingStore});
        Assert.assertThrows(RuntimeException.class, () -> ((CachingKeyValueStore)this.store).close());
        EasyMock.verify((Object[])new Object[]{this.cache, this.underlyingStore});
    }

    @Test
    public void shouldCloseCacheAfterErrorDuringStateStoreClose() {
        this.setUpCloseTests();
        EasyMock.reset((Object[])new Object[]{this.cache});
        this.cache.flush(CACHE_NAMESPACE);
        this.cache.close(CACHE_NAMESPACE);
        EasyMock.replay((Object[])new Object[]{this.cache});
        EasyMock.reset((Object[])new Object[]{this.underlyingStore});
        this.underlyingStore.close();
        EasyMock.expectLastCall().andThrow((Throwable)new RuntimeException("Simulating an error on close"));
        EasyMock.replay((Object[])new Object[]{this.underlyingStore});
        Assert.assertThrows(RuntimeException.class, () -> ((CachingKeyValueStore)this.store).close());
        EasyMock.verify((Object[])new Object[]{this.cache, this.underlyingStore});
    }

    private void setUpCloseTests() {
        this.underlyingStore = (KeyValueStore)EasyMock.createNiceMock(KeyValueStore.class);
        EasyMock.expect((Object)this.underlyingStore.name()).andStubReturn((Object)"store-name");
        EasyMock.expect((Object)this.underlyingStore.isOpen()).andStubReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.underlyingStore});
        this.store = new CachingKeyValueStore(this.underlyingStore);
        this.cache = (ThreadCache)EasyMock.niceMock(ThreadCache.class);
        this.context = new InternalMockProcessorContext(TestUtils.tempDirectory(), null, null, null, this.cache);
        this.context.setRecordContext(new ProcessorRecordContext(10L, 0L, 0, TOPIC, null));
        this.store.init((StateStoreContext)this.context, (StateStore)this.store);
    }

    @Test
    public void shouldPutGetToFromCache() {
        this.store.put(this.bytesKey("key"), this.bytesValue("value"));
        this.store.put(this.bytesKey("key2"), this.bytesValue("value2"));
        MatcherAssert.assertThat((Object)this.store.get(this.bytesKey("key")), (Matcher)CoreMatchers.equalTo((Object)this.bytesValue("value")));
        MatcherAssert.assertThat((Object)this.store.get(this.bytesKey("key2")), (Matcher)CoreMatchers.equalTo((Object)this.bytesValue("value2")));
        Assert.assertEquals((long)2L, (long)this.cache.size());
        Assert.assertEquals((long)0L, (long)this.underlyingStore.approximateNumEntries());
    }

    private byte[] bytesValue(String value) {
        return value.getBytes();
    }

    private Bytes bytesKey(String key) {
        return Bytes.wrap((byte[])key.getBytes());
    }

    @Test
    public void shouldFlushEvictedItemsIntoUnderlyingStore() {
        int added = this.addItemsToCache();
        Assert.assertEquals((long)added, (long)this.underlyingStore.approximateNumEntries());
        Assert.assertEquals((long)added, (long)this.store.approximateNumEntries());
        Assert.assertNotNull((Object)this.underlyingStore.get((Object)Bytes.wrap((byte[])"0".getBytes())));
    }

    @Test
    public void shouldForwardDirtyItemToListenerWhenEvicted() {
        int numRecords = this.addItemsToCache();
        Assert.assertEquals((long)numRecords, (long)this.cacheFlushListener.forwarded.size());
    }

    @Test
    public void shouldForwardDirtyItemsWhenFlushCalled() {
        this.store.put(this.bytesKey("1"), this.bytesValue("a"));
        this.store.flush();
        Assert.assertEquals((Object)"a", (Object)this.cacheFlushListener.forwarded.get((Object)"1").newValue);
        Assert.assertNull((Object)this.cacheFlushListener.forwarded.get((Object)"1").oldValue);
    }

    @Test
    public void shouldForwardOldValuesWhenEnabled() {
        this.store.setFlushListener(this.cacheFlushListener, true);
        this.store.put(this.bytesKey("1"), this.bytesValue("a"));
        this.store.flush();
        Assert.assertEquals((Object)"a", (Object)this.cacheFlushListener.forwarded.get((Object)"1").newValue);
        Assert.assertNull((Object)this.cacheFlushListener.forwarded.get((Object)"1").oldValue);
        this.store.put(this.bytesKey("1"), this.bytesValue("b"));
        this.store.put(this.bytesKey("1"), this.bytesValue("c"));
        this.store.flush();
        Assert.assertEquals((Object)"c", (Object)this.cacheFlushListener.forwarded.get((Object)"1").newValue);
        Assert.assertEquals((Object)"a", (Object)this.cacheFlushListener.forwarded.get((Object)"1").oldValue);
        this.store.put(this.bytesKey("1"), null);
        this.store.flush();
        Assert.assertNull((Object)this.cacheFlushListener.forwarded.get((Object)"1").newValue);
        Assert.assertEquals((Object)"c", (Object)this.cacheFlushListener.forwarded.get((Object)"1").oldValue);
        this.cacheFlushListener.forwarded.clear();
        this.store.put(this.bytesKey("1"), this.bytesValue("a"));
        this.store.put(this.bytesKey("1"), this.bytesValue("b"));
        this.store.put(this.bytesKey("1"), null);
        this.store.flush();
        Assert.assertNull(this.cacheFlushListener.forwarded.get("1"));
        this.cacheFlushListener.forwarded.clear();
    }

    @Test
    public void shouldNotForwardOldValuesWhenDisabled() {
        this.store.put(this.bytesKey("1"), this.bytesValue("a"));
        this.store.flush();
        Assert.assertEquals((Object)"a", (Object)this.cacheFlushListener.forwarded.get((Object)"1").newValue);
        Assert.assertNull((Object)this.cacheFlushListener.forwarded.get((Object)"1").oldValue);
        this.store.put(this.bytesKey("1"), this.bytesValue("b"));
        this.store.flush();
        Assert.assertEquals((Object)"b", (Object)this.cacheFlushListener.forwarded.get((Object)"1").newValue);
        Assert.assertNull((Object)this.cacheFlushListener.forwarded.get((Object)"1").oldValue);
        this.store.put(this.bytesKey("1"), null);
        this.store.flush();
        Assert.assertNull((Object)this.cacheFlushListener.forwarded.get((Object)"1").newValue);
        Assert.assertNull((Object)this.cacheFlushListener.forwarded.get((Object)"1").oldValue);
        this.cacheFlushListener.forwarded.clear();
        this.store.put(this.bytesKey("1"), this.bytesValue("a"));
        this.store.put(this.bytesKey("1"), this.bytesValue("b"));
        this.store.put(this.bytesKey("1"), null);
        this.store.flush();
        Assert.assertNull(this.cacheFlushListener.forwarded.get("1"));
        this.cacheFlushListener.forwarded.clear();
    }

    @Test
    public void shouldIterateAllStoredItems() {
        int items = this.addItemsToCache();
        KeyValueIterator all = this.store.all();
        ArrayList<Object> results = new ArrayList<Object>();
        while (all.hasNext()) {
            results.add(((KeyValue)all.next()).key);
        }
        Assert.assertEquals((long)items, (long)results.size());
        Assert.assertEquals(Arrays.asList(Bytes.wrap((byte[])"0".getBytes()), Bytes.wrap((byte[])"1".getBytes()), Bytes.wrap((byte[])"2".getBytes())), results);
    }

    @Test
    public void shouldReverseIterateAllStoredItems() {
        int items = this.addItemsToCache();
        KeyValueIterator all = this.store.reverseAll();
        ArrayList<Object> results = new ArrayList<Object>();
        while (all.hasNext()) {
            results.add(((KeyValue)all.next()).key);
        }
        Assert.assertEquals((long)items, (long)results.size());
        Assert.assertEquals(Arrays.asList(Bytes.wrap((byte[])"2".getBytes()), Bytes.wrap((byte[])"1".getBytes()), Bytes.wrap((byte[])"0".getBytes())), results);
    }

    @Test
    public void shouldIterateOverRange() {
        int items = this.addItemsToCache();
        KeyValueIterator range = this.store.range(this.bytesKey(String.valueOf(0)), this.bytesKey(String.valueOf(items)));
        ArrayList<Object> results = new ArrayList<Object>();
        while (range.hasNext()) {
            results.add(((KeyValue)range.next()).key);
        }
        Assert.assertEquals((long)items, (long)results.size());
        Assert.assertEquals(Arrays.asList(Bytes.wrap((byte[])"0".getBytes()), Bytes.wrap((byte[])"1".getBytes()), Bytes.wrap((byte[])"2".getBytes())), results);
    }

    @Test
    public void shouldReverseIterateOverRange() {
        int items = this.addItemsToCache();
        KeyValueIterator range = this.store.reverseRange(this.bytesKey(String.valueOf(0)), this.bytesKey(String.valueOf(items)));
        ArrayList<Object> results = new ArrayList<Object>();
        while (range.hasNext()) {
            results.add(((KeyValue)range.next()).key);
        }
        Assert.assertEquals((long)items, (long)results.size());
        Assert.assertEquals(Arrays.asList(Bytes.wrap((byte[])"2".getBytes()), Bytes.wrap((byte[])"1".getBytes()), Bytes.wrap((byte[])"0".getBytes())), results);
    }

    @Test
    public void shouldGetRecordsWithPrefixKey() {
        ArrayList<KeyValue> entries = new ArrayList<KeyValue>();
        entries.add(new KeyValue((Object)this.bytesKey("p11"), (Object)this.bytesValue("2")));
        entries.add(new KeyValue((Object)this.bytesKey("k1"), (Object)this.bytesValue("1")));
        entries.add(new KeyValue((Object)this.bytesKey("k2"), (Object)this.bytesValue("2")));
        entries.add(new KeyValue((Object)this.bytesKey("p2"), (Object)this.bytesValue("2")));
        entries.add(new KeyValue((Object)this.bytesKey("p1"), (Object)this.bytesValue("2")));
        entries.add(new KeyValue((Object)this.bytesKey("p0"), (Object)this.bytesValue("2")));
        this.store.putAll(entries);
        KeyValueIterator keysWithPrefix = this.store.prefixScan((Object)"p1", (Serializer)new StringSerializer());
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        int numberOfKeysReturned = 0;
        while (keysWithPrefix.hasNext()) {
            KeyValue next = (KeyValue)keysWithPrefix.next();
            keys.add(((Bytes)next.key).toString());
            values.add(new String((byte[])next.value));
            ++numberOfKeysReturned;
        }
        MatcherAssert.assertThat((Object)numberOfKeysReturned, (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat(keys, (Matcher)CoreMatchers.is(Arrays.asList("p1", "p11")));
        MatcherAssert.assertThat(values, (Matcher)CoreMatchers.is(Arrays.asList("2", "2")));
    }

    @Test
    public void shouldGetRecordsWithPrefixKeyExcludingNextLargestKey() {
        ArrayList<KeyValue> entries = new ArrayList<KeyValue>();
        entries.add(new KeyValue((Object)this.bytesKey("abcd"), (Object)this.bytesValue("2")));
        entries.add(new KeyValue((Object)this.bytesKey("abcdd"), (Object)this.bytesValue("1")));
        entries.add(new KeyValue((Object)this.bytesKey("abce"), (Object)this.bytesValue("2")));
        entries.add(new KeyValue((Object)this.bytesKey("abc"), (Object)this.bytesValue("2")));
        this.store.putAll(entries);
        KeyValueIterator keysWithPrefix = this.store.prefixScan((Object)"abcd", (Serializer)new StringSerializer());
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        int numberOfKeysReturned = 0;
        while (keysWithPrefix.hasNext()) {
            KeyValue next = (KeyValue)keysWithPrefix.next();
            keys.add(((Bytes)next.key).toString());
            values.add(new String((byte[])next.value));
            ++numberOfKeysReturned;
        }
        MatcherAssert.assertThat((Object)numberOfKeysReturned, (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat(keys, (Matcher)CoreMatchers.is(Arrays.asList("abcd", "abcdd")));
        MatcherAssert.assertThat(values, (Matcher)CoreMatchers.is(Arrays.asList("2", "1")));
    }

    @Test
    public void shouldDeleteItemsFromCache() {
        this.store.put(this.bytesKey("a"), this.bytesValue("a"));
        this.store.delete(this.bytesKey("a"));
        Assert.assertNull((Object)this.store.get(this.bytesKey("a")));
        Assert.assertFalse((boolean)this.store.range(this.bytesKey("a"), this.bytesKey("b")).hasNext());
        Assert.assertFalse((boolean)this.store.reverseRange(this.bytesKey("a"), this.bytesKey("b")).hasNext());
        Assert.assertFalse((boolean)this.store.all().hasNext());
        Assert.assertFalse((boolean)this.store.reverseAll().hasNext());
    }

    @Test
    public void shouldNotShowItemsDeletedFromCacheButFlushedToStoreBeforeDelete() {
        this.store.put(this.bytesKey("a"), this.bytesValue("a"));
        this.store.flush();
        this.store.delete(this.bytesKey("a"));
        Assert.assertNull((Object)this.store.get(this.bytesKey("a")));
        Assert.assertFalse((boolean)this.store.range(this.bytesKey("a"), this.bytesKey("b")).hasNext());
        Assert.assertFalse((boolean)this.store.reverseRange(this.bytesKey("a"), this.bytesKey("b")).hasNext());
        Assert.assertFalse((boolean)this.store.all().hasNext());
        Assert.assertFalse((boolean)this.store.reverseAll().hasNext());
    }

    @Test
    public void shouldClearNamespaceCacheOnClose() {
        this.store.put(this.bytesKey("a"), this.bytesValue("a"));
        Assert.assertEquals((long)1L, (long)this.cache.size());
        this.store.close();
        Assert.assertEquals((long)0L, (long)this.cache.size());
    }

    @Test
    public void shouldThrowIfTryingToGetFromClosedCachingStore() {
        Assert.assertThrows(InvalidStateStoreException.class, () -> {
            this.store.close();
            this.store.get(this.bytesKey("a"));
        });
    }

    @Test
    public void shouldThrowIfTryingToWriteToClosedCachingStore() {
        Assert.assertThrows(InvalidStateStoreException.class, () -> {
            this.store.close();
            this.store.put(this.bytesKey("a"), this.bytesValue("a"));
        });
    }

    @Test
    public void shouldThrowIfTryingToDoRangeQueryOnClosedCachingStore() {
        Assert.assertThrows(InvalidStateStoreException.class, () -> {
            this.store.close();
            this.store.range(this.bytesKey("a"), this.bytesKey("b"));
        });
    }

    @Test
    public void shouldThrowIfTryingToDoReverseRangeQueryOnClosedCachingStore() {
        Assert.assertThrows(InvalidStateStoreException.class, () -> {
            this.store.close();
            this.store.reverseRange(this.bytesKey("a"), this.bytesKey("b"));
        });
    }

    @Test
    public void shouldThrowIfTryingToDoAllQueryOnClosedCachingStore() {
        Assert.assertThrows(InvalidStateStoreException.class, () -> {
            this.store.close();
            this.store.all();
        });
    }

    @Test
    public void shouldThrowIfTryingToDoReverseAllQueryOnClosedCachingStore() {
        Assert.assertThrows(InvalidStateStoreException.class, () -> {
            this.store.close();
            this.store.reverseAll();
        });
    }

    @Test
    public void shouldThrowIfTryingToDoGetApproxSizeOnClosedCachingStore() {
        Assert.assertThrows(InvalidStateStoreException.class, () -> {
            this.store.close();
            this.store.close();
            this.store.approximateNumEntries();
        });
    }

    @Test
    public void shouldThrowIfTryingToDoPutAllClosedCachingStore() {
        Assert.assertThrows(InvalidStateStoreException.class, () -> {
            this.store.close();
            this.store.putAll(Collections.singletonList(KeyValue.pair((Object)this.bytesKey("a"), (Object)this.bytesValue("a"))));
        });
    }

    @Test
    public void shouldThrowIfTryingToDoPutIfAbsentClosedCachingStore() {
        Assert.assertThrows(InvalidStateStoreException.class, () -> {
            this.store.close();
            this.store.putIfAbsent(this.bytesKey("b"), this.bytesValue("c"));
        });
    }

    @Test
    public void shouldThrowNullPointerExceptionOnPutWithNullKey() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.put(null, this.bytesValue("c")));
    }

    @Test
    public void shouldThrowNullPointerExceptionOnPutIfAbsentWithNullKey() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.putIfAbsent(null, this.bytesValue("c")));
    }

    @Test
    public void shouldThrowNullPointerExceptionOnPutAllWithNullKey() {
        ArrayList<KeyValue> entries = new ArrayList<KeyValue>();
        entries.add(new KeyValue(null, (Object)this.bytesValue("a")));
        Assert.assertThrows(NullPointerException.class, () -> this.store.putAll(entries));
    }

    @Test
    public void shouldPutIfAbsent() {
        this.store.putIfAbsent(this.bytesKey("b"), this.bytesValue("2"));
        MatcherAssert.assertThat((Object)this.store.get(this.bytesKey("b")), (Matcher)CoreMatchers.equalTo((Object)this.bytesValue("2")));
        this.store.putIfAbsent(this.bytesKey("b"), this.bytesValue("3"));
        MatcherAssert.assertThat((Object)this.store.get(this.bytesKey("b")), (Matcher)CoreMatchers.equalTo((Object)this.bytesValue("2")));
    }

    @Override
    @Test
    public void shouldPutAll() {
        ArrayList<KeyValue> entries = new ArrayList<KeyValue>();
        entries.add(new KeyValue((Object)this.bytesKey("a"), (Object)this.bytesValue("1")));
        entries.add(new KeyValue((Object)this.bytesKey("b"), (Object)this.bytesValue("2")));
        this.store.putAll(entries);
        MatcherAssert.assertThat((Object)this.store.get(this.bytesKey("a")), (Matcher)CoreMatchers.equalTo((Object)this.bytesValue("1")));
        MatcherAssert.assertThat((Object)this.store.get(this.bytesKey("b")), (Matcher)CoreMatchers.equalTo((Object)this.bytesValue("2")));
    }

    @Test
    public void shouldReturnUnderlying() {
        Assert.assertEquals(this.underlyingStore, (Object)this.store.wrapped());
    }

    @Test
    public void shouldThrowIfTryingToDeleteFromClosedCachingStore() {
        Assert.assertThrows(InvalidStateStoreException.class, () -> {
            this.store.close();
            this.store.delete(this.bytesKey("key"));
        });
    }

    private int addItemsToCache() {
        String kv;
        int i = 0;
        for (int cachedSize = 0; cachedSize < 150; cachedSize += ThreadCacheTest.memoryCacheEntrySize(kv.getBytes(), kv.getBytes(), TOPIC)) {
            kv = String.valueOf(i++);
            this.store.put(this.bytesKey(kv), this.bytesValue(kv));
        }
        return i;
    }
}

