/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.streams.kstream.TimeWindowedDeserializer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TimeWindowedDeserializerTest {
    private final long windowSize = 5000000L;
    private final TimeWindowedDeserializer<?> timeWindowedDeserializer = new TimeWindowedDeserializer(null, Long.valueOf(5000000L));
    private final Map<String, String> props = new HashMap<String, String>();

    @Before
    public void setUp() {
        this.props.put("default.windowed.key.serde.inner", Serdes.StringSerde.class.getName());
        this.props.put("default.windowed.value.serde.inner", Serdes.ByteArraySerde.class.getName());
    }

    @Test
    public void testWindowedKeyDeserializerNoArgConstructors() {
        this.timeWindowedDeserializer.configure(this.props, true);
        Deserializer inner = this.timeWindowedDeserializer.innerDeserializer();
        Assert.assertNotNull((String)"Inner deserializer should be not null", (Object)inner);
        Assert.assertTrue((String)"Inner deserializer type should be StringDeserializer", (boolean)(inner instanceof StringDeserializer));
        MatcherAssert.assertThat((Object)this.timeWindowedDeserializer.getWindowSize(), (Matcher)Is.is((Object)5000000L));
    }

    @Test
    public void testWindowedValueDeserializerNoArgConstructors() {
        this.timeWindowedDeserializer.configure(this.props, false);
        Deserializer inner = this.timeWindowedDeserializer.innerDeserializer();
        Assert.assertNotNull((String)"Inner deserializer should be not null", (Object)inner);
        Assert.assertTrue((String)"Inner deserializer type should be ByteArrayDeserializer", (boolean)(inner instanceof ByteArrayDeserializer));
        MatcherAssert.assertThat((Object)this.timeWindowedDeserializer.getWindowSize(), (Matcher)Is.is((Object)5000000L));
    }

    @Test
    public void shouldSetWindowSizeThroughConfigs() {
        this.props.put("window.size.ms", "500");
        TimeWindowedDeserializer deserializer = new TimeWindowedDeserializer();
        deserializer.configure(this.props, false);
        MatcherAssert.assertThat((Object)deserializer.getWindowSize(), (Matcher)Is.is((Object)500L));
    }

    @Test
    public void shouldThrowErrorIfWindowSizeSetInConfigsAndConstructor() {
        this.props.put("window.size.ms", "500");
        Assert.assertThrows(IllegalArgumentException.class, () -> this.timeWindowedDeserializer.configure(this.props, false));
    }

    @Test
    public void shouldThrowErrorIfWindowSizeIsNotSet() {
        TimeWindowedDeserializer deserializer = new TimeWindowedDeserializer();
        Assert.assertThrows(IllegalArgumentException.class, () -> deserializer.configure(this.props, false));
    }
}

