/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.internals;

import java.time.Duration;
import java.time.Instant;

public final class ApiUtils {
    private static final String MILLISECOND_VALIDATION_FAIL_MSG_FRMT = "Invalid value for parameter \"%s\" (value was: %s). ";
    private static final String VALIDATE_MILLISECOND_NULL_SUFFIX = "It shouldn't be null.";
    private static final String VALIDATE_MILLISECOND_OVERFLOW_SUFFIX = "It can't be converted to milliseconds.";

    private ApiUtils() {
    }

    public static long validateMillisecondDuration(Duration duration, String messagePrefix) {
        try {
            if (duration == null) {
                throw new IllegalArgumentException(messagePrefix + VALIDATE_MILLISECOND_NULL_SUFFIX);
            }
            return duration.toMillis();
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException(messagePrefix + VALIDATE_MILLISECOND_OVERFLOW_SUFFIX, e);
        }
    }

    public static long validateMillisecondInstant(Instant instant, String messagePrefix) {
        try {
            if (instant == null) {
                throw new IllegalArgumentException(messagePrefix + VALIDATE_MILLISECOND_NULL_SUFFIX);
            }
            return instant.toEpochMilli();
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException(messagePrefix + VALIDATE_MILLISECOND_OVERFLOW_SUFFIX, e);
        }
    }

    public static String prepareMillisCheckFailMsgPrefix(Object value, String name) {
        return String.format(MILLISECOND_VALIDATION_FAIL_MSG_FRMT, name, value);
    }
}

