/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.kafka.common.utils.AbstractIterator;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.errors.ProcessorStateException;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.TimestampedBytesStore;
import org.apache.kafka.streams.state.internals.RocksDBStore;
import org.apache.kafka.streams.state.internals.StoreQueryUtils;
import org.apache.kafka.streams.state.internals.metrics.RocksDBMetricsRecorder;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.WriteBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBTimestampedStore
extends RocksDBStore
implements TimestampedBytesStore {
    private static final Logger log = LoggerFactory.getLogger(RocksDBTimestampedStore.class);

    RocksDBTimestampedStore(String name, String metricsScope) {
        super(name, metricsScope);
    }

    RocksDBTimestampedStore(String name, String parentDir, RocksDBMetricsRecorder metricsRecorder) {
        super(name, parentDir, metricsRecorder);
    }

    @Override
    void openRocksDB(DBOptions dbOptions, ColumnFamilyOptions columnFamilyOptions) {
        List<ColumnFamilyDescriptor> columnFamilyDescriptors = Arrays.asList(new ColumnFamilyDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY, columnFamilyOptions), new ColumnFamilyDescriptor("keyValueWithTimestamp".getBytes(StandardCharsets.UTF_8), columnFamilyOptions));
        ArrayList<ColumnFamilyHandle> columnFamilies = new ArrayList<ColumnFamilyHandle>(columnFamilyDescriptors.size());
        try {
            this.db = RocksDB.open((DBOptions)dbOptions, (String)this.dbDir.getAbsolutePath(), columnFamilyDescriptors, columnFamilies);
            this.setDbAccessor((ColumnFamilyHandle)columnFamilies.get(0), (ColumnFamilyHandle)columnFamilies.get(1));
        }
        catch (RocksDBException e) {
            if ("Column family not found: keyValueWithTimestamp".equals(e.getMessage())) {
                try {
                    this.db = RocksDB.open((DBOptions)dbOptions, (String)this.dbDir.getAbsolutePath(), columnFamilyDescriptors.subList(0, 1), columnFamilies);
                    columnFamilies.add(this.db.createColumnFamily(columnFamilyDescriptors.get(1)));
                }
                catch (RocksDBException fatal) {
                    throw new ProcessorStateException("Error opening store " + this.name + " at location " + this.dbDir.toString(), fatal);
                }
                this.setDbAccessor((ColumnFamilyHandle)columnFamilies.get(0), (ColumnFamilyHandle)columnFamilies.get(1));
            }
            throw new ProcessorStateException("Error opening store " + this.name + " at location " + this.dbDir.toString(), e);
        }
    }

    private void setDbAccessor(ColumnFamilyHandle noTimestampColumnFamily, ColumnFamilyHandle withTimestampColumnFamily) {
        RocksIterator noTimestampsIter = this.db.newIterator(noTimestampColumnFamily);
        noTimestampsIter.seekToFirst();
        if (noTimestampsIter.isValid()) {
            log.info("Opening store {} in upgrade mode", (Object)this.name);
            this.dbAccessor = new DualColumnFamilyAccessor(noTimestampColumnFamily, withTimestampColumnFamily);
        } else {
            log.info("Opening store {} in regular mode", (Object)this.name);
            this.dbAccessor = new RocksDBStore.SingleColumnFamilyAccessor(this, withTimestampColumnFamily);
            noTimestampColumnFamily.close();
        }
        noTimestampsIter.close();
    }

    private class RocksDBDualCFRangeIterator
    extends RocksDBDualCFIterator {
        private final Comparator<byte[]> comparator;
        private final byte[] rawLastKey;
        private final boolean forward;
        private final boolean toInclusive;

        RocksDBDualCFRangeIterator(String storeName, RocksIterator iterWithTimestamp, RocksIterator iterNoTimestamp, Bytes from, Bytes to, boolean forward, boolean toInclusive) {
            super(storeName, iterWithTimestamp, iterNoTimestamp, forward);
            this.comparator = Bytes.BYTES_LEXICO_COMPARATOR;
            this.forward = forward;
            this.toInclusive = toInclusive;
            if (forward) {
                if (from == null) {
                    iterWithTimestamp.seekToFirst();
                    iterNoTimestamp.seekToFirst();
                } else {
                    iterWithTimestamp.seek(from.get());
                    iterNoTimestamp.seek(from.get());
                }
                this.rawLastKey = to == null ? null : to.get();
            } else {
                if (to == null) {
                    iterWithTimestamp.seekToLast();
                    iterNoTimestamp.seekToLast();
                } else {
                    iterWithTimestamp.seekForPrev(to.get());
                    iterNoTimestamp.seekForPrev(to.get());
                }
                this.rawLastKey = from == null ? null : from.get();
            }
        }

        @Override
        public KeyValue<Bytes, byte[]> makeNext() {
            Object next = super.makeNext();
            if (next == null) {
                return (KeyValue)this.allDone();
            }
            if (this.rawLastKey == null) {
                return next;
            }
            if (this.forward) {
                if (this.comparator.compare(((Bytes)((KeyValue)next).key).get(), this.rawLastKey) < 0) {
                    return next;
                }
                if (this.comparator.compare(((Bytes)((KeyValue)next).key).get(), this.rawLastKey) == 0) {
                    return this.toInclusive ? next : (KeyValue)this.allDone();
                }
                return (KeyValue)this.allDone();
            }
            if (this.comparator.compare(((Bytes)((KeyValue)next).key).get(), this.rawLastKey) >= 0) {
                return next;
            }
            return (KeyValue)this.allDone();
        }
    }

    private class RocksDBDualCFIterator
    extends AbstractIterator<KeyValue<Bytes, byte[]>>
    implements KeyValueIterator<Bytes, byte[]> {
        private final Comparator<byte[]> comparator = Bytes.BYTES_LEXICO_COMPARATOR;
        private final String storeName;
        private final RocksIterator iterWithTimestamp;
        private final RocksIterator iterNoTimestamp;
        private final boolean forward;
        private volatile boolean open = true;
        private byte[] nextWithTimestamp;
        private byte[] nextNoTimestamp;
        private KeyValue<Bytes, byte[]> next;

        RocksDBDualCFIterator(String storeName, RocksIterator iterWithTimestamp, RocksIterator iterNoTimestamp, boolean forward) {
            this.iterWithTimestamp = iterWithTimestamp;
            this.iterNoTimestamp = iterNoTimestamp;
            this.storeName = storeName;
            this.forward = forward;
        }

        @Override
        public synchronized boolean hasNext() {
            if (!this.open) {
                throw new InvalidStateStoreException(String.format("RocksDB iterator for store %s has closed", this.storeName));
            }
            return super.hasNext();
        }

        @Override
        public synchronized KeyValue<Bytes, byte[]> next() {
            return (KeyValue)super.next();
        }

        public KeyValue<Bytes, byte[]> makeNext() {
            if (this.nextNoTimestamp == null && this.iterNoTimestamp.isValid()) {
                this.nextNoTimestamp = this.iterNoTimestamp.key();
            }
            if (this.nextWithTimestamp == null && this.iterWithTimestamp.isValid()) {
                this.nextWithTimestamp = this.iterWithTimestamp.key();
            }
            if (this.nextNoTimestamp == null && !this.iterNoTimestamp.isValid()) {
                if (this.nextWithTimestamp == null && !this.iterWithTimestamp.isValid()) {
                    return (KeyValue)this.allDone();
                }
                this.next = KeyValue.pair(new Bytes(this.nextWithTimestamp), this.iterWithTimestamp.value());
                this.nextWithTimestamp = null;
                if (this.forward) {
                    this.iterWithTimestamp.next();
                } else {
                    this.iterWithTimestamp.prev();
                }
            } else if (this.nextWithTimestamp == null) {
                this.next = KeyValue.pair(new Bytes(this.nextNoTimestamp), TimestampedBytesStore.convertToTimestampedFormat(this.iterNoTimestamp.value()));
                this.nextNoTimestamp = null;
                if (this.forward) {
                    this.iterNoTimestamp.next();
                } else {
                    this.iterNoTimestamp.prev();
                }
            } else if (this.forward) {
                if (this.comparator.compare(this.nextNoTimestamp, this.nextWithTimestamp) <= 0) {
                    this.next = KeyValue.pair(new Bytes(this.nextNoTimestamp), TimestampedBytesStore.convertToTimestampedFormat(this.iterNoTimestamp.value()));
                    this.nextNoTimestamp = null;
                    this.iterNoTimestamp.next();
                } else {
                    this.next = KeyValue.pair(new Bytes(this.nextWithTimestamp), this.iterWithTimestamp.value());
                    this.nextWithTimestamp = null;
                    this.iterWithTimestamp.next();
                }
            } else if (this.comparator.compare(this.nextNoTimestamp, this.nextWithTimestamp) >= 0) {
                this.next = KeyValue.pair(new Bytes(this.nextNoTimestamp), TimestampedBytesStore.convertToTimestampedFormat(this.iterNoTimestamp.value()));
                this.nextNoTimestamp = null;
                this.iterNoTimestamp.prev();
            } else {
                this.next = KeyValue.pair(new Bytes(this.nextWithTimestamp), this.iterWithTimestamp.value());
                this.nextWithTimestamp = null;
                this.iterWithTimestamp.prev();
            }
            return this.next;
        }

        @Override
        public synchronized void close() {
            RocksDBTimestampedStore.this.openIterators.remove(this);
            this.iterNoTimestamp.close();
            this.iterWithTimestamp.close();
            this.open = false;
        }

        @Override
        public Bytes peekNextKey() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return (Bytes)this.next.key;
        }
    }

    private class DualColumnFamilyAccessor
    implements RocksDBStore.RocksDBAccessor {
        private final ColumnFamilyHandle oldColumnFamily;
        private final ColumnFamilyHandle newColumnFamily;

        private DualColumnFamilyAccessor(ColumnFamilyHandle oldColumnFamily, ColumnFamilyHandle newColumnFamily) {
            this.oldColumnFamily = oldColumnFamily;
            this.newColumnFamily = newColumnFamily;
        }

        @Override
        public void put(byte[] key, byte[] valueWithTimestamp) {
            if (valueWithTimestamp == null) {
                try {
                    RocksDBTimestampedStore.this.db.delete(this.oldColumnFamily, RocksDBTimestampedStore.this.wOptions, key);
                }
                catch (RocksDBException e) {
                    throw new ProcessorStateException("Error while removing key from store " + RocksDBTimestampedStore.this.name, e);
                }
                try {
                    RocksDBTimestampedStore.this.db.delete(this.newColumnFamily, RocksDBTimestampedStore.this.wOptions, key);
                }
                catch (RocksDBException e) {
                    throw new ProcessorStateException("Error while removing key from store " + RocksDBTimestampedStore.this.name, e);
                }
            }
            try {
                RocksDBTimestampedStore.this.db.delete(this.oldColumnFamily, RocksDBTimestampedStore.this.wOptions, key);
            }
            catch (RocksDBException e) {
                throw new ProcessorStateException("Error while removing key from store " + RocksDBTimestampedStore.this.name, e);
            }
            try {
                RocksDBTimestampedStore.this.db.put(this.newColumnFamily, RocksDBTimestampedStore.this.wOptions, key, valueWithTimestamp);
                StoreQueryUtils.updatePosition(RocksDBTimestampedStore.this.position, RocksDBTimestampedStore.this.context);
            }
            catch (RocksDBException e) {
                throw new ProcessorStateException("Error while putting key/value into store " + RocksDBTimestampedStore.this.name, e);
            }
        }

        @Override
        public void prepareBatch(List<KeyValue<Bytes, byte[]>> entries, WriteBatch batch) throws RocksDBException {
            for (KeyValue<Bytes, byte[]> entry : entries) {
                Objects.requireNonNull(entry.key, "key cannot be null");
                this.addToBatch(((Bytes)entry.key).get(), (byte[])entry.value, batch);
            }
        }

        @Override
        public byte[] get(byte[] key) throws RocksDBException {
            byte[] valueWithTimestamp = RocksDBTimestampedStore.this.db.get(this.newColumnFamily, key);
            if (valueWithTimestamp != null) {
                return valueWithTimestamp;
            }
            byte[] plainValue = RocksDBTimestampedStore.this.db.get(this.oldColumnFamily, key);
            if (plainValue != null) {
                byte[] valueWithUnknownTimestamp = TimestampedBytesStore.convertToTimestampedFormat(plainValue);
                this.put(key, valueWithUnknownTimestamp);
                return valueWithUnknownTimestamp;
            }
            return null;
        }

        @Override
        public byte[] getOnly(byte[] key) throws RocksDBException {
            byte[] valueWithTimestamp = RocksDBTimestampedStore.this.db.get(this.newColumnFamily, key);
            if (valueWithTimestamp != null) {
                return valueWithTimestamp;
            }
            byte[] plainValue = RocksDBTimestampedStore.this.db.get(this.oldColumnFamily, key);
            if (plainValue != null) {
                return TimestampedBytesStore.convertToTimestampedFormat(plainValue);
            }
            return null;
        }

        @Override
        public KeyValueIterator<Bytes, byte[]> range(Bytes from, Bytes to, boolean forward) {
            return new RocksDBDualCFRangeIterator(RocksDBTimestampedStore.this.name, RocksDBTimestampedStore.this.db.newIterator(this.newColumnFamily), RocksDBTimestampedStore.this.db.newIterator(this.oldColumnFamily), from, to, forward, true);
        }

        @Override
        public void deleteRange(byte[] from, byte[] to) {
            try {
                RocksDBTimestampedStore.this.db.deleteRange(this.oldColumnFamily, RocksDBTimestampedStore.this.wOptions, from, to);
            }
            catch (RocksDBException e) {
                throw new ProcessorStateException("Error while removing key from store " + RocksDBTimestampedStore.this.name, e);
            }
            try {
                RocksDBTimestampedStore.this.db.deleteRange(this.newColumnFamily, RocksDBTimestampedStore.this.wOptions, from, to);
            }
            catch (RocksDBException e) {
                throw new ProcessorStateException("Error while removing key from store " + RocksDBTimestampedStore.this.name, e);
            }
        }

        @Override
        public KeyValueIterator<Bytes, byte[]> all(boolean forward) {
            RocksIterator innerIterWithTimestamp = RocksDBTimestampedStore.this.db.newIterator(this.newColumnFamily);
            RocksIterator innerIterNoTimestamp = RocksDBTimestampedStore.this.db.newIterator(this.oldColumnFamily);
            if (forward) {
                innerIterWithTimestamp.seekToFirst();
                innerIterNoTimestamp.seekToFirst();
            } else {
                innerIterWithTimestamp.seekToLast();
                innerIterNoTimestamp.seekToLast();
            }
            return new RocksDBDualCFIterator(RocksDBTimestampedStore.this.name, innerIterWithTimestamp, innerIterNoTimestamp, forward);
        }

        @Override
        public KeyValueIterator<Bytes, byte[]> prefixScan(Bytes prefix) {
            Bytes to = Bytes.increment((Bytes)prefix);
            return new RocksDBDualCFRangeIterator(RocksDBTimestampedStore.this.name, RocksDBTimestampedStore.this.db.newIterator(this.newColumnFamily), RocksDBTimestampedStore.this.db.newIterator(this.oldColumnFamily), prefix, to, true, false);
        }

        @Override
        public long approximateNumEntries() throws RocksDBException {
            return RocksDBTimestampedStore.this.db.getLongProperty(this.oldColumnFamily, "rocksdb.estimate-num-keys") + RocksDBTimestampedStore.this.db.getLongProperty(this.newColumnFamily, "rocksdb.estimate-num-keys");
        }

        @Override
        public void flush() throws RocksDBException {
            RocksDBTimestampedStore.this.db.flush(RocksDBTimestampedStore.this.fOptions, this.oldColumnFamily);
            RocksDBTimestampedStore.this.db.flush(RocksDBTimestampedStore.this.fOptions, this.newColumnFamily);
        }

        @Override
        public void addToBatch(byte[] key, byte[] value, WriteBatch batch) throws RocksDBException {
            if (value == null) {
                batch.delete(this.oldColumnFamily, key);
                batch.delete(this.newColumnFamily, key);
            } else {
                batch.delete(this.oldColumnFamily, key);
                batch.put(this.newColumnFamily, key, value);
            }
        }

        @Override
        public void close() {
            this.oldColumnFamily.close();
            this.newColumnFamily.close();
        }
    }
}

