/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.state.internals.CacheFlushListener;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

class SessionTupleForwarder<K, V> {
    private final ProcessorContext<Windowed<K>, Change<V>> context;
    private final boolean sendOldValues;
    private final boolean cachingEnabled;

    SessionTupleForwarder(StateStore store, ProcessorContext<Windowed<K>, Change<V>> context, CacheFlushListener<Windowed<K>, V> flushListener, boolean sendOldValues) {
        this.context = context;
        this.sendOldValues = sendOldValues;
        this.cachingEnabled = ((WrappedStateStore)store).setFlushListener(flushListener, sendOldValues);
    }

    public void maybeForward(Windowed<K> key, V newValue, V oldValue) {
        if (!this.cachingEnabled) {
            this.context.forward(new Record<Windowed<K>, Change<V>>(key, new Change<V>(newValue, this.sendOldValues ? oldValue : null), key.window().end()));
        }
    }
}

