/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Map;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.Windows;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KStreamAggProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.TimestampedCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.TimestampedTupleForwarder;
import org.apache.kafka.streams.processor.api.ContextualProcessor;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.api.RecordMetadata;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.TaskMetrics;
import org.apache.kafka.streams.state.TimestampedWindowStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KStreamWindowAggregate<KIn, VIn, VAgg, W extends Window>
implements KStreamAggProcessorSupplier<KIn, VIn, Windowed<KIn>, VAgg> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String storeName;
    private final Windows<W> windows;
    private final Initializer<VAgg> initializer;
    private final Aggregator<? super KIn, ? super VIn, VAgg> aggregator;
    private boolean sendOldValues = false;

    public KStreamWindowAggregate(Windows<W> windows, String storeName, Initializer<VAgg> initializer, Aggregator<? super KIn, ? super VIn, VAgg> aggregator) {
        this.windows = windows;
        this.storeName = storeName;
        this.initializer = initializer;
        this.aggregator = aggregator;
    }

    @Override
    public Processor<KIn, VIn, Windowed<KIn>, Change<VAgg>> get() {
        return new KStreamWindowAggregateProcessor();
    }

    public Windows<W> windows() {
        return this.windows;
    }

    @Override
    public void enableSendingOldValues() {
        this.sendOldValues = true;
    }

    @Override
    public KTableValueGetterSupplier<Windowed<KIn>, VAgg> view() {
        return new KTableValueGetterSupplier<Windowed<KIn>, VAgg>(){

            @Override
            public KTableValueGetter<Windowed<KIn>, VAgg> get() {
                return new KStreamWindowAggregateValueGetter();
            }

            @Override
            public String[] storeNames() {
                return new String[]{KStreamWindowAggregate.this.storeName};
            }
        };
    }

    private class KStreamWindowAggregateValueGetter
    implements KTableValueGetter<Windowed<KIn>, VAgg> {
        private TimestampedWindowStore<KIn, VAgg> windowStore;

        private KStreamWindowAggregateValueGetter() {
        }

        @Override
        public void init(org.apache.kafka.streams.processor.ProcessorContext context) {
            this.windowStore = (TimestampedWindowStore)context.getStateStore(KStreamWindowAggregate.this.storeName);
        }

        @Override
        public ValueAndTimestamp<VAgg> get(Windowed<KIn> windowedKey) {
            Object key = windowedKey.key();
            Window window = windowedKey.window();
            return (ValueAndTimestamp)this.windowStore.fetch(key, window.start());
        }
    }

    private class KStreamWindowAggregateProcessor
    extends ContextualProcessor<KIn, VIn, Windowed<KIn>, Change<VAgg>> {
        private TimestampedWindowStore<KIn, VAgg> windowStore;
        private TimestampedTupleForwarder<Windowed<KIn>, VAgg> tupleForwarder;
        private Sensor droppedRecordsSensor;
        private long observedStreamTime = -1L;

        private KStreamWindowAggregateProcessor() {
        }

        @Override
        public void init(ProcessorContext<Windowed<KIn>, Change<VAgg>> context) {
            super.init(context);
            InternalProcessorContext internalProcessorContext = (InternalProcessorContext)context;
            StreamsMetricsImpl metrics = internalProcessorContext.metrics();
            String threadId = Thread.currentThread().getName();
            this.droppedRecordsSensor = TaskMetrics.droppedRecordsSensor(threadId, context.taskId().toString(), metrics);
            this.windowStore = (TimestampedWindowStore)context.getStateStore(KStreamWindowAggregate.this.storeName);
            this.tupleForwarder = new TimestampedTupleForwarder(this.windowStore, context, new TimestampedCacheFlushListener(context), KStreamWindowAggregate.this.sendOldValues);
        }

        @Override
        public void process(Record<KIn, VIn> record) {
            if (record.key() == null) {
                if (this.context().recordMetadata().isPresent()) {
                    RecordMetadata recordMetadata = this.context().recordMetadata().get();
                    KStreamWindowAggregate.this.log.warn("Skipping record due to null key. topic=[{}] partition=[{}] offset=[{}]", new Object[]{recordMetadata.topic(), recordMetadata.partition(), recordMetadata.offset()});
                } else {
                    KStreamWindowAggregate.this.log.warn("Skipping record due to null key. Topic, partition, and offset not known.");
                }
                this.droppedRecordsSensor.record();
                return;
            }
            long timestamp = record.timestamp();
            this.observedStreamTime = Math.max(this.observedStreamTime, timestamp);
            long closeTime = this.observedStreamTime - KStreamWindowAggregate.this.windows.gracePeriodMs();
            Map matchedWindows = KStreamWindowAggregate.this.windows.windowsFor(timestamp);
            for (Map.Entry entry : matchedWindows.entrySet()) {
                Long windowStart = entry.getKey();
                long windowEnd = ((Window)entry.getValue()).end();
                if (windowEnd > closeTime) {
                    long newTimestamp;
                    ValueAndTimestamp oldAggAndTimestamp = (ValueAndTimestamp)this.windowStore.fetch(record.key(), windowStart);
                    Object oldAgg = ValueAndTimestamp.getValueOrNull(oldAggAndTimestamp);
                    if (oldAgg == null) {
                        oldAgg = KStreamWindowAggregate.this.initializer.apply();
                        newTimestamp = record.timestamp();
                    } else {
                        newTimestamp = Math.max(record.timestamp(), oldAggAndTimestamp.timestamp());
                    }
                    Object newAgg = KStreamWindowAggregate.this.aggregator.apply(record.key(), record.value(), oldAgg);
                    this.windowStore.put(record.key(), ValueAndTimestamp.make(newAgg, newTimestamp), windowStart);
                    this.tupleForwarder.maybeForward(new Windowed(record.key(), (Window)entry.getValue()), newAgg, KStreamWindowAggregate.this.sendOldValues ? oldAgg : null, newTimestamp);
                    continue;
                }
                if (this.context().recordMetadata().isPresent()) {
                    RecordMetadata recordMetadata = this.context().recordMetadata().get();
                    KStreamWindowAggregate.this.log.warn("Skipping record for expired window. topic=[{}] partition=[{}] offset=[{}] timestamp=[{}] window=[{},{}) expiration=[{}] streamTime=[{}]", new Object[]{recordMetadata.topic(), recordMetadata.partition(), recordMetadata.offset(), record.timestamp(), windowStart, windowEnd, closeTime, this.observedStreamTime});
                } else {
                    KStreamWindowAggregate.this.log.warn("Skipping record for expired window. Topic, partition, and offset not known. timestamp=[{}] window=[{},{}] expiration=[{}] streamTime=[{}]", new Object[]{record.timestamp(), windowStart, windowEnd, closeTime, this.observedStreamTime});
                }
                this.droppedRecordsSensor.record();
            }
        }
    }
}

