/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.List;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.internals.HasNextCondition;
import org.apache.kafka.streams.state.internals.Segment;
import org.apache.kafka.streams.state.internals.Segments;

public interface SegmentedBytesStore
extends StateStore {
    public KeyValueIterator<Bytes, byte[]> fetch(Bytes var1, long var2, long var4);

    public KeyValueIterator<Bytes, byte[]> backwardFetch(Bytes var1, long var2, long var4);

    public KeyValueIterator<Bytes, byte[]> fetch(Bytes var1, Bytes var2, long var3, long var5);

    public KeyValueIterator<Bytes, byte[]> backwardFetch(Bytes var1, Bytes var2, long var3, long var5);

    public KeyValueIterator<Bytes, byte[]> all();

    public KeyValueIterator<Bytes, byte[]> backwardAll();

    public KeyValueIterator<Bytes, byte[]> fetchAll(long var1, long var3);

    public KeyValueIterator<Bytes, byte[]> backwardFetchAll(long var1, long var3);

    public void remove(Bytes var1);

    public void remove(Bytes var1, long var2);

    public void put(Bytes var1, byte[] var2);

    public byte[] get(Bytes var1);

    public static interface KeySchema {
        public Bytes upperRange(Bytes var1, long var2);

        public Bytes lowerRange(Bytes var1, long var2);

        default public Bytes toStoreBinaryKeyPrefix(Bytes key, long timestamp) {
            throw new UnsupportedOperationException();
        }

        public Bytes upperRangeFixedSize(Bytes var1, long var2);

        public Bytes lowerRangeFixedSize(Bytes var1, long var2);

        public long segmentTimestamp(Bytes var1);

        public HasNextCondition hasNextCondition(Bytes var1, Bytes var2, long var3, long var5);

        public <S extends Segment> List<S> segmentsToSearch(Segments<S> var1, long var2, long var4, boolean var6);
    }
}

