/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Objects;

public class KeyAndJoinSide<K> {
    private final K key;
    private final boolean leftSide;

    private KeyAndJoinSide(boolean leftSide, K key) {
        this.key = Objects.requireNonNull(key, "key cannot be null");
        this.leftSide = leftSide;
    }

    public static <K> KeyAndJoinSide<K> make(boolean leftSide, K key) {
        return new KeyAndJoinSide<K>(leftSide, key);
    }

    public boolean isLeftSide() {
        return this.leftSide;
    }

    public K getKey() {
        return this.key;
    }

    public String toString() {
        String joinSide = this.leftSide ? "left" : "right";
        return "<" + joinSide + "," + this.key + ">";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyAndJoinSide that = (KeyAndJoinSide)o;
        return this.leftSide == that.leftSide && Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.leftSide, this.key);
    }
}

