/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state;

import java.util.Objects;

public final class ValueAndTimestamp<V> {
    private final V value;
    private final long timestamp;

    private ValueAndTimestamp(V value, long timestamp) {
        Objects.requireNonNull(value);
        this.value = value;
        this.timestamp = timestamp;
    }

    public static <V> ValueAndTimestamp<V> make(V value, long timestamp) {
        return value == null ? null : new ValueAndTimestamp<V>(value, timestamp);
    }

    public static <V> V getValueOrNull(ValueAndTimestamp<V> valueAndTimestamp) {
        return valueAndTimestamp == null ? null : (V)valueAndTimestamp.value();
    }

    public V value() {
        return this.value;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "<" + this.value + "," + this.timestamp + ">";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueAndTimestamp that = (ValueAndTimestamp)o;
        return this.timestamp == that.timestamp && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.timestamp);
    }
}

