/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams;

import java.util.Set;
import java.util.regex.Pattern;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.TopologyDescription;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.processor.StreamPartitioner;
import org.apache.kafka.streams.processor.TimestampExtractor;
import org.apache.kafka.streams.processor.TopicNameExtractor;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.processor.internals.ProcessorAdapter;
import org.apache.kafka.streams.state.StoreBuilder;

public class Topology {
    protected final InternalTopologyBuilder internalTopologyBuilder = new InternalTopologyBuilder();

    public synchronized Topology addSource(String name, String ... topics) {
        this.internalTopologyBuilder.addSource(null, name, null, null, null, topics);
        return this;
    }

    public synchronized Topology addSource(String name, Pattern topicPattern) {
        this.internalTopologyBuilder.addSource(null, name, null, null, null, topicPattern);
        return this;
    }

    public synchronized Topology addSource(AutoOffsetReset offsetReset, String name, String ... topics) {
        this.internalTopologyBuilder.addSource(offsetReset, name, null, null, null, topics);
        return this;
    }

    public synchronized Topology addSource(AutoOffsetReset offsetReset, String name, Pattern topicPattern) {
        this.internalTopologyBuilder.addSource(offsetReset, name, null, null, null, topicPattern);
        return this;
    }

    public synchronized Topology addSource(TimestampExtractor timestampExtractor, String name, String ... topics) {
        this.internalTopologyBuilder.addSource(null, name, timestampExtractor, null, null, topics);
        return this;
    }

    public synchronized Topology addSource(TimestampExtractor timestampExtractor, String name, Pattern topicPattern) {
        this.internalTopologyBuilder.addSource(null, name, timestampExtractor, null, null, topicPattern);
        return this;
    }

    public synchronized Topology addSource(AutoOffsetReset offsetReset, TimestampExtractor timestampExtractor, String name, String ... topics) {
        this.internalTopologyBuilder.addSource(offsetReset, name, timestampExtractor, null, null, topics);
        return this;
    }

    public synchronized Topology addSource(AutoOffsetReset offsetReset, TimestampExtractor timestampExtractor, String name, Pattern topicPattern) {
        this.internalTopologyBuilder.addSource(offsetReset, name, timestampExtractor, null, null, topicPattern);
        return this;
    }

    public synchronized Topology addSource(String name, Deserializer<?> keyDeserializer, Deserializer<?> valueDeserializer, String ... topics) {
        this.internalTopologyBuilder.addSource(null, name, null, keyDeserializer, valueDeserializer, topics);
        return this;
    }

    public synchronized Topology addSource(String name, Deserializer<?> keyDeserializer, Deserializer<?> valueDeserializer, Pattern topicPattern) {
        this.internalTopologyBuilder.addSource(null, name, null, keyDeserializer, valueDeserializer, topicPattern);
        return this;
    }

    public synchronized Topology addSource(AutoOffsetReset offsetReset, String name, Deserializer<?> keyDeserializer, Deserializer<?> valueDeserializer, String ... topics) {
        this.internalTopologyBuilder.addSource(offsetReset, name, null, keyDeserializer, valueDeserializer, topics);
        return this;
    }

    public synchronized Topology addSource(AutoOffsetReset offsetReset, String name, Deserializer<?> keyDeserializer, Deserializer<?> valueDeserializer, Pattern topicPattern) {
        this.internalTopologyBuilder.addSource(offsetReset, name, null, keyDeserializer, valueDeserializer, topicPattern);
        return this;
    }

    public synchronized Topology addSource(AutoOffsetReset offsetReset, String name, TimestampExtractor timestampExtractor, Deserializer<?> keyDeserializer, Deserializer<?> valueDeserializer, String ... topics) {
        this.internalTopologyBuilder.addSource(offsetReset, name, timestampExtractor, keyDeserializer, valueDeserializer, topics);
        return this;
    }

    public synchronized Topology addSource(AutoOffsetReset offsetReset, String name, TimestampExtractor timestampExtractor, Deserializer<?> keyDeserializer, Deserializer<?> valueDeserializer, Pattern topicPattern) {
        this.internalTopologyBuilder.addSource(offsetReset, name, timestampExtractor, keyDeserializer, valueDeserializer, topicPattern);
        return this;
    }

    public synchronized Topology addSink(String name, String topic, String ... parentNames) {
        this.internalTopologyBuilder.addSink(name, topic, null, null, null, parentNames);
        return this;
    }

    public synchronized <K, V> Topology addSink(String name, String topic, StreamPartitioner<? super K, ? super V> partitioner, String ... parentNames) {
        this.internalTopologyBuilder.addSink(name, topic, null, null, partitioner, parentNames);
        return this;
    }

    public synchronized <K, V> Topology addSink(String name, String topic, Serializer<K> keySerializer, Serializer<V> valueSerializer, String ... parentNames) {
        this.internalTopologyBuilder.addSink(name, topic, keySerializer, valueSerializer, null, parentNames);
        return this;
    }

    public synchronized <K, V> Topology addSink(String name, String topic, Serializer<K> keySerializer, Serializer<V> valueSerializer, StreamPartitioner<? super K, ? super V> partitioner, String ... parentNames) {
        this.internalTopologyBuilder.addSink(name, topic, keySerializer, valueSerializer, partitioner, parentNames);
        return this;
    }

    public synchronized <K, V> Topology addSink(String name, TopicNameExtractor<K, V> topicExtractor, String ... parentNames) {
        this.internalTopologyBuilder.addSink(name, topicExtractor, null, null, null, parentNames);
        return this;
    }

    public synchronized <K, V> Topology addSink(String name, TopicNameExtractor<K, V> topicExtractor, StreamPartitioner<? super K, ? super V> partitioner, String ... parentNames) {
        this.internalTopologyBuilder.addSink(name, topicExtractor, null, null, partitioner, parentNames);
        return this;
    }

    public synchronized <K, V> Topology addSink(String name, TopicNameExtractor<K, V> topicExtractor, Serializer<K> keySerializer, Serializer<V> valueSerializer, String ... parentNames) {
        this.internalTopologyBuilder.addSink(name, topicExtractor, keySerializer, valueSerializer, null, parentNames);
        return this;
    }

    public synchronized <K, V> Topology addSink(String name, TopicNameExtractor<K, V> topicExtractor, Serializer<K> keySerializer, Serializer<V> valueSerializer, StreamPartitioner<? super K, ? super V> partitioner, String ... parentNames) {
        this.internalTopologyBuilder.addSink(name, topicExtractor, keySerializer, valueSerializer, partitioner, parentNames);
        return this;
    }

    @Deprecated
    public synchronized Topology addProcessor(String name, final ProcessorSupplier supplier, String ... parentNames) {
        return this.addProcessor(name, new org.apache.kafka.streams.processor.api.ProcessorSupplier<Object, Object, Object, Object>(){

            @Override
            public Set<StoreBuilder<?>> stores() {
                return supplier.stores();
            }

            @Override
            public org.apache.kafka.streams.processor.api.Processor<Object, Object, Object, Object> get() {
                return ProcessorAdapter.adaptRaw((Processor)supplier.get());
            }
        }, parentNames);
    }

    public synchronized <KIn, VIn, KOut, VOut> Topology addProcessor(String name, org.apache.kafka.streams.processor.api.ProcessorSupplier<KIn, VIn, KOut, VOut> supplier, String ... parentNames) {
        this.internalTopologyBuilder.addProcessor(name, supplier, parentNames);
        Set<StoreBuilder<?>> stores = supplier.stores();
        if (stores != null) {
            for (StoreBuilder<?> storeBuilder : stores) {
                this.internalTopologyBuilder.addStateStore(storeBuilder, name);
            }
        }
        return this;
    }

    public synchronized Topology addStateStore(StoreBuilder<?> storeBuilder, String ... processorNames) {
        this.internalTopologyBuilder.addStateStore(storeBuilder, processorNames);
        return this;
    }

    @Deprecated
    public synchronized <K, V> Topology addGlobalStore(StoreBuilder<?> storeBuilder, String sourceName, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer, String topic, String processorName, ProcessorSupplier<K, V> stateUpdateSupplier) {
        this.internalTopologyBuilder.addGlobalStore(storeBuilder, sourceName, null, keyDeserializer, valueDeserializer, topic, processorName, () -> ProcessorAdapter.adapt(stateUpdateSupplier.get()));
        return this;
    }

    @Deprecated
    public synchronized <K, V> Topology addGlobalStore(StoreBuilder<?> storeBuilder, String sourceName, TimestampExtractor timestampExtractor, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer, String topic, String processorName, ProcessorSupplier<K, V> stateUpdateSupplier) {
        this.internalTopologyBuilder.addGlobalStore(storeBuilder, sourceName, timestampExtractor, keyDeserializer, valueDeserializer, topic, processorName, () -> ProcessorAdapter.adapt(stateUpdateSupplier.get()));
        return this;
    }

    public synchronized <KIn, VIn> Topology addGlobalStore(StoreBuilder<?> storeBuilder, String sourceName, Deserializer<KIn> keyDeserializer, Deserializer<VIn> valueDeserializer, String topic, String processorName, org.apache.kafka.streams.processor.api.ProcessorSupplier<KIn, VIn, Void, Void> stateUpdateSupplier) {
        this.internalTopologyBuilder.addGlobalStore(storeBuilder, sourceName, null, keyDeserializer, valueDeserializer, topic, processorName, stateUpdateSupplier);
        return this;
    }

    public synchronized <KIn, VIn> Topology addGlobalStore(StoreBuilder<?> storeBuilder, String sourceName, TimestampExtractor timestampExtractor, Deserializer<KIn> keyDeserializer, Deserializer<VIn> valueDeserializer, String topic, String processorName, org.apache.kafka.streams.processor.api.ProcessorSupplier<KIn, VIn, Void, Void> stateUpdateSupplier) {
        this.internalTopologyBuilder.addGlobalStore(storeBuilder, sourceName, timestampExtractor, keyDeserializer, valueDeserializer, topic, processorName, stateUpdateSupplier);
        return this;
    }

    public synchronized Topology connectProcessorAndStateStores(String processorName, String ... stateStoreNames) {
        this.internalTopologyBuilder.connectProcessorAndStateStores(processorName, stateStoreNames);
        return this;
    }

    public synchronized TopologyDescription describe() {
        return this.internalTopologyBuilder.describe();
    }

    public static enum AutoOffsetReset {
        EARLIEST,
        LATEST;

    }
}

