/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.streams.kstream.Branched;
import org.apache.kafka.streams.kstream.BranchedKStream;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.kstream.internals.BranchedInternal;
import org.apache.kafka.streams.kstream.internals.KStreamBranch;
import org.apache.kafka.streams.kstream.internals.KStreamImpl;
import org.apache.kafka.streams.kstream.internals.NamedInternal;
import org.apache.kafka.streams.kstream.internals.PassThrough;
import org.apache.kafka.streams.kstream.internals.graph.ProcessorGraphNode;
import org.apache.kafka.streams.kstream.internals.graph.ProcessorParameters;

public class BranchedKStreamImpl<K, V>
implements BranchedKStream<K, V> {
    private static final String BRANCH_NAME = "KSTREAM-BRANCH-";
    private final KStreamImpl<K, V> source;
    private final boolean repartitionRequired;
    private final String splitterName;
    private final Map<String, KStream<K, V>> outputBranches = new HashMap<String, KStream<K, V>>();
    private final List<Predicate<? super K, ? super V>> predicates = new ArrayList<Predicate<? super K, ? super V>>();
    private final List<String> childNames = new ArrayList<String>();
    private final ProcessorGraphNode<K, V> splitterNode;

    BranchedKStreamImpl(KStreamImpl<K, V> source, boolean repartitionRequired, NamedInternal named) {
        this.source = source;
        this.repartitionRequired = repartitionRequired;
        this.splitterName = named.orElseGenerateWithPrefix(source.builder, BRANCH_NAME);
        ProcessorParameters processorParameters = new ProcessorParameters(new KStreamBranch<K, V>(this.predicates, this.childNames), this.splitterName);
        this.splitterNode = new ProcessorGraphNode<K, V>(this.splitterName, processorParameters);
        source.builder.addGraphNode(source.graphNode, this.splitterNode);
    }

    @Override
    public BranchedKStream<K, V> branch(Predicate<? super K, ? super V> predicate) {
        return this.branch(predicate, BranchedInternal.empty());
    }

    @Override
    public BranchedKStream<K, V> branch(Predicate<? super K, ? super V> predicate, Branched<K, V> branched) {
        this.predicates.add(predicate);
        this.createBranch(branched, this.predicates.size());
        return this;
    }

    @Override
    public Map<String, KStream<K, V>> defaultBranch() {
        return this.defaultBranch(BranchedInternal.empty());
    }

    @Override
    public Map<String, KStream<K, V>> defaultBranch(Branched<K, V> branched) {
        this.createBranch(branched, 0);
        return this.outputBranches;
    }

    private void createBranch(Branched<K, V> branched, int index) {
        BranchedInternal<K, V> branchedInternal = new BranchedInternal<K, V>(branched);
        String branchChildName = this.getBranchChildName(index, branchedInternal);
        this.childNames.add(branchChildName);
        this.source.builder.newProcessorName(branchChildName);
        ProcessorParameters parameters = new ProcessorParameters(new PassThrough(), branchChildName);
        ProcessorGraphNode branchChildNode = new ProcessorGraphNode(branchChildName, parameters);
        this.source.builder.addGraphNode(this.splitterNode, branchChildNode);
        KStreamImpl branch = new KStreamImpl(branchChildName, this.source.keySerde, this.source.valueSerde, this.source.subTopologySourceNodes, this.repartitionRequired, branchChildNode, this.source.builder);
        this.process(branch, branchChildName, branchedInternal);
    }

    private String getBranchChildName(int index, BranchedInternal<K, V> branchedInternal) {
        if (branchedInternal.name() == null) {
            return this.splitterName + index;
        }
        return this.splitterName + branchedInternal.name();
    }

    private void process(KStreamImpl<K, V> branch, String branchChildName, BranchedInternal<K, V> branchedInternal) {
        if (branchedInternal.chainFunction() != null) {
            KStream<K, V> transformedStream = branchedInternal.chainFunction().apply(branch);
            if (transformedStream != null) {
                this.outputBranches.put(branchChildName, transformedStream);
            }
        } else if (branchedInternal.chainConsumer() != null) {
            branchedInternal.chainConsumer().accept(branch);
        } else {
            this.outputBranches.put(branchChildName, branch);
        }
    }

    @Override
    public Map<String, KStream<K, V>> noDefaultBranch() {
        return this.outputBranches;
    }
}

