/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.kstream.internals.ProducedInternal;
import org.apache.kafka.streams.kstream.internals.WindowedSerializer;
import org.apache.kafka.streams.kstream.internals.WindowedStreamPartitioner;
import org.apache.kafka.streams.kstream.internals.graph.StreamsGraphNode;
import org.apache.kafka.streams.processor.StreamPartitioner;
import org.apache.kafka.streams.processor.TopicNameExtractor;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.processor.internals.StaticTopicNameExtractor;

public class StreamSinkNode<K, V>
extends StreamsGraphNode {
    private final TopicNameExtractor<K, V> topicNameExtractor;
    private final ProducedInternal<K, V> producedInternal;

    public StreamSinkNode(String nodeName, TopicNameExtractor<K, V> topicNameExtractor, ProducedInternal<K, V> producedInternal) {
        super(nodeName);
        this.topicNameExtractor = topicNameExtractor;
        this.producedInternal = producedInternal;
    }

    @Override
    public String toString() {
        return "StreamSinkNode{topicNameExtractor=" + this.topicNameExtractor + ", producedInternal=" + this.producedInternal + "} " + super.toString();
    }

    @Override
    public void writeToTopology(InternalTopologyBuilder topologyBuilder) {
        Serializer keySerializer = this.producedInternal.keySerde() == null ? null : this.producedInternal.keySerde().serializer();
        Serializer valSerializer = this.producedInternal.valueSerde() == null ? null : this.producedInternal.valueSerde().serializer();
        String[] parentNames = this.parentNodeNames();
        StreamPartitioner<K, V> partitioner = this.producedInternal.streamPartitioner() == null && keySerializer instanceof WindowedSerializer ? new WindowedStreamPartitioner((WindowedSerializer)keySerializer) : this.producedInternal.streamPartitioner();
        if (this.topicNameExtractor instanceof StaticTopicNameExtractor) {
            String topicName = ((StaticTopicNameExtractor)this.topicNameExtractor).topicName;
            topologyBuilder.addSink(this.nodeName(), topicName, keySerializer, valSerializer, partitioner, parentNames);
        } else {
            topologyBuilder.addSink(this.nodeName(), this.topicNameExtractor, keySerializer, valSerializer, partitioner, parentNames);
        }
    }
}

