/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.KTableMaterializedValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.KTableProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.TimestampedCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.TimestampedTupleForwarder;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;

class KTableFilter<K, V>
implements KTableProcessorSupplier<K, V, V> {
    private final KTableImpl<K, ?, V> parent;
    private final Predicate<? super K, ? super V> predicate;
    private final boolean filterNot;
    private final String queryableName;
    private boolean sendOldValues;

    KTableFilter(KTableImpl<K, ?, V> parent, Predicate<? super K, ? super V> predicate, boolean filterNot, String queryableName) {
        this.parent = parent;
        this.predicate = predicate;
        this.filterNot = filterNot;
        this.queryableName = queryableName;
        this.sendOldValues = parent.enableSendingOldValues(false);
    }

    @Override
    public Processor<K, Change<V>> get() {
        return new KTableFilterProcessor();
    }

    @Override
    public boolean enableSendingOldValues(boolean forceMaterialization) {
        if (this.queryableName != null) {
            this.sendOldValues = true;
            return true;
        }
        if (this.parent.enableSendingOldValues(forceMaterialization)) {
            this.sendOldValues = true;
        }
        return this.sendOldValues;
    }

    private V computeValue(K key, V value) {
        V newValue = null;
        if (value != null && this.filterNot ^ this.predicate.test(key, value)) {
            newValue = value;
        }
        return newValue;
    }

    private ValueAndTimestamp<V> computeValue(K key, ValueAndTimestamp<V> valueAndTimestamp) {
        V value;
        ValueAndTimestamp<V> newValueAndTimestamp = null;
        if (valueAndTimestamp != null && this.filterNot ^ this.predicate.test(key, value = valueAndTimestamp.value())) {
            newValueAndTimestamp = valueAndTimestamp;
        }
        return newValueAndTimestamp;
    }

    @Override
    public KTableValueGetterSupplier<K, V> view() {
        if (this.queryableName != null) {
            return new KTableMaterializedValueGetterSupplier(this.queryableName);
        }
        return new KTableValueGetterSupplier<K, V>(){
            final KTableValueGetterSupplier<K, V> parentValueGetterSupplier;
            {
                this.parentValueGetterSupplier = KTableFilter.this.parent.valueGetterSupplier();
            }

            @Override
            public KTableValueGetter<K, V> get() {
                return new KTableFilterValueGetter(this.parentValueGetterSupplier.get());
            }

            @Override
            public String[] storeNames() {
                return this.parentValueGetterSupplier.storeNames();
            }
        };
    }

    private class KTableFilterValueGetter
    implements KTableValueGetter<K, V> {
        private final KTableValueGetter<K, V> parentGetter;

        KTableFilterValueGetter(KTableValueGetter<K, V> parentGetter) {
            this.parentGetter = parentGetter;
        }

        @Override
        public void init(ProcessorContext context) {
            this.parentGetter.init(context);
        }

        @Override
        public ValueAndTimestamp<V> get(K key) {
            return KTableFilter.this.computeValue(key, this.parentGetter.get(key));
        }

        @Override
        public void close() {
            this.parentGetter.close();
        }
    }

    private class KTableFilterProcessor
    extends AbstractProcessor<K, Change<V>> {
        private TimestampedKeyValueStore<K, V> store;
        private TimestampedTupleForwarder<K, V> tupleForwarder;

        private KTableFilterProcessor() {
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            if (KTableFilter.this.queryableName != null) {
                this.store = (TimestampedKeyValueStore)context.getStateStore(KTableFilter.this.queryableName);
                this.tupleForwarder = new TimestampedTupleForwarder(this.store, context, new TimestampedCacheFlushListener(context), KTableFilter.this.sendOldValues);
            }
        }

        @Override
        public void process(K key, Change<V> change) {
            Object newValue = KTableFilter.this.computeValue(key, change.newValue);
            Object oldValue = this.computeOldValue(key, change);
            if (KTableFilter.this.sendOldValues && oldValue == null && newValue == null) {
                return;
            }
            if (KTableFilter.this.queryableName != null) {
                this.store.put(key, ValueAndTimestamp.make(newValue, this.context().timestamp()));
                this.tupleForwarder.maybeForward(key, newValue, oldValue);
            } else {
                this.context().forward(key, new Change<Object>(newValue, oldValue));
            }
        }

        private V computeOldValue(K key, Change<V> change) {
            if (!KTableFilter.this.sendOldValues) {
                return null;
            }
            return KTableFilter.this.queryableName != null ? ValueAndTimestamp.getValueOrNull((ValueAndTimestamp)this.store.get(key)) : KTableFilter.this.computeValue(key, change.oldValue);
        }
    }
}

