/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.streams.StoreQueryParameters;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.internals.StateStoreProvider;
import org.apache.kafka.streams.state.internals.StreamThreadStateStoreProvider;

public class WrappingStoreProvider
implements StateStoreProvider {
    private final List<StreamThreadStateStoreProvider> storeProviders;
    private StoreQueryParameters storeQueryParameters;

    WrappingStoreProvider(List<StreamThreadStateStoreProvider> storeProviders, StoreQueryParameters storeQueryParameters) {
        this.storeProviders = storeProviders;
        this.storeQueryParameters = storeQueryParameters;
    }

    public void setStoreQueryParameters(StoreQueryParameters storeQueryParameters) {
        this.storeQueryParameters = storeQueryParameters;
    }

    @Override
    public <T> List<T> stores(String storeName, QueryableStoreType<T> queryableStoreType) {
        ArrayList allStores = new ArrayList();
        for (StreamThreadStateStoreProvider storeProvider : this.storeProviders) {
            List stores = storeProvider.stores(this.storeQueryParameters);
            if (stores.isEmpty()) continue;
            allStores.addAll(stores);
            if (this.storeQueryParameters.partition() == null) continue;
            break;
        }
        if (allStores.isEmpty()) {
            if (this.storeQueryParameters.partition() != null) {
                throw new InvalidStateStoreException(String.format("The specified partition %d for store %s does not exist.", this.storeQueryParameters.partition(), storeName));
            }
            throw new InvalidStateStoreException("The state store, " + storeName + ", may have migrated to another instance.");
        }
        return allStores;
    }
}

