/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.streams.processor.TaskMetadata;

public class ThreadMetadata {
    private final String threadName;
    private final String threadState;
    private final Set<TaskMetadata> activeTasks;
    private final Set<TaskMetadata> standbyTasks;
    private final String mainConsumerClientId;
    private final String restoreConsumerClientId;
    private final Set<String> producerClientIds;
    private final String adminClientId;

    public ThreadMetadata(String threadName, String threadState, String mainConsumerClientId, String restoreConsumerClientId, Set<String> producerClientIds, String adminClientId, Set<TaskMetadata> activeTasks, Set<TaskMetadata> standbyTasks) {
        this.mainConsumerClientId = mainConsumerClientId;
        this.restoreConsumerClientId = restoreConsumerClientId;
        this.producerClientIds = producerClientIds;
        this.adminClientId = adminClientId;
        this.threadName = threadName;
        this.threadState = threadState;
        this.activeTasks = Collections.unmodifiableSet(activeTasks);
        this.standbyTasks = Collections.unmodifiableSet(standbyTasks);
    }

    public String threadState() {
        return this.threadState;
    }

    public String threadName() {
        return this.threadName;
    }

    public Set<TaskMetadata> activeTasks() {
        return this.activeTasks;
    }

    public Set<TaskMetadata> standbyTasks() {
        return this.standbyTasks;
    }

    public String consumerClientId() {
        return this.mainConsumerClientId;
    }

    public String restoreConsumerClientId() {
        return this.restoreConsumerClientId;
    }

    public Set<String> producerClientIds() {
        return this.producerClientIds;
    }

    public String adminClientId() {
        return this.adminClientId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThreadMetadata that = (ThreadMetadata)o;
        return Objects.equals(this.threadName, that.threadName) && Objects.equals(this.threadState, that.threadState) && Objects.equals(this.activeTasks, that.activeTasks) && Objects.equals(this.standbyTasks, that.standbyTasks) && this.mainConsumerClientId.equals(that.mainConsumerClientId) && this.restoreConsumerClientId.equals(that.restoreConsumerClientId) && Objects.equals(this.producerClientIds, that.producerClientIds) && this.adminClientId.equals(that.adminClientId);
    }

    public int hashCode() {
        return Objects.hash(this.threadName, this.threadState, this.activeTasks, this.standbyTasks, this.mainConsumerClientId, this.restoreConsumerClientId, this.producerClientIds, this.adminClientId);
    }

    public String toString() {
        return "ThreadMetadata{threadName=" + this.threadName + ", threadState=" + this.threadState + ", activeTasks=" + this.activeTasks + ", standbyTasks=" + this.standbyTasks + ", consumerClientId=" + this.mainConsumerClientId + ", restoreConsumerClientId=" + this.restoreConsumerClientId + ", producerClientIds=" + this.producerClientIds + ", adminClientId=" + this.adminClientId + '}';
    }
}

