/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.internals.generated;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.Bytes;

public class SubscriptionInfoData
implements ApiMessage {
    private int version;
    private int latestSupportedVersion;
    private UUID processId;
    private List<TaskId> prevTasks;
    private List<TaskId> standbyTasks;
    private byte[] userEndPoint;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("version", (Type)Type.INT32, ""), new Field("process_id", (Type)Type.UUID, ""), new Field("prev_tasks", (Type)new ArrayOf((Type)TaskId.SCHEMA_1), ""), new Field("standby_tasks", (Type)new ArrayOf((Type)TaskId.SCHEMA_1), "")});
    public static final Schema SCHEMA_2 = new Schema(new Field[]{new Field("version", (Type)Type.INT32, ""), new Field("process_id", (Type)Type.UUID, ""), new Field("prev_tasks", (Type)new ArrayOf((Type)TaskId.SCHEMA_1), ""), new Field("standby_tasks", (Type)new ArrayOf((Type)TaskId.SCHEMA_1), ""), new Field("user_end_point", (Type)Type.BYTES, "")});
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema SCHEMA_6;
    public static final Schema[] SCHEMAS;

    public SubscriptionInfoData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public SubscriptionInfoData(Struct struct, short _version) {
        this.fromStruct(struct, _version);
    }

    public SubscriptionInfoData() {
        this.version = 0;
        this.latestSupportedVersion = -1;
        this.processId = MessageUtil.ZERO_UUID;
        this.prevTasks = new ArrayList<TaskId>();
        this.standbyTasks = new ArrayList<TaskId>();
        this.userEndPoint = Bytes.EMPTY;
    }

    public short apiKey() {
        return -1;
    }

    public short lowestSupportedVersion() {
        return 1;
    }

    public short highestSupportedVersion() {
        return 6;
    }

    public void read(Readable _readable, short _version) {
        int i;
        this.version = _readable.readInt();
        this.latestSupportedVersion = _version >= 3 ? _readable.readInt() : -1;
        this.processId = _readable.readUUID();
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field prevTasks was serialized as null");
        }
        ArrayList<TaskId> newCollection = new ArrayList<TaskId>(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add(new TaskId(_readable, _version));
        }
        this.prevTasks = newCollection;
        arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field standbyTasks was serialized as null");
        }
        newCollection = new ArrayList(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add(new TaskId(_readable, _version));
        }
        this.standbyTasks = newCollection;
        if (_version >= 2) {
            int length = _readable.readInt();
            if (length < 0) {
                throw new RuntimeException("non-nullable field userEndPoint was serialized as null");
            }
            byte[] newBytes = new byte[length];
            _readable.readArray(newBytes);
            this.userEndPoint = newBytes;
        } else {
            this.userEndPoint = Bytes.EMPTY;
        }
        this._unknownTaggedFields = null;
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.version);
        if (_version >= 3) {
            _writable.writeInt(this.latestSupportedVersion);
        } else if (this.latestSupportedVersion != -1) {
            throw new UnsupportedVersionException("Attempted to write a non-default latestSupportedVersion at version " + _version);
        }
        _writable.writeUUID(this.processId);
        _writable.writeInt(this.prevTasks.size());
        for (TaskId prevTasksElement : this.prevTasks) {
            prevTasksElement.write(_writable, _cache, _version);
        }
        _writable.writeInt(this.standbyTasks.size());
        for (TaskId standbyTasksElement : this.standbyTasks) {
            standbyTasksElement.write(_writable, _cache, _version);
        }
        if (_version >= 2) {
            _writable.writeInt(this.userEndPoint.length);
            _writable.writeByteArray(this.userEndPoint);
        } else if (this.userEndPoint.length != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default userEndPoint at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void fromStruct(Struct struct, short _version) {
        this._unknownTaggedFields = null;
        this.version = struct.getInt("version");
        this.latestSupportedVersion = _version >= 3 ? struct.getInt("latest_supported_version") : -1;
        this.processId = struct.getUUID("process_id");
        Object[] _nestedObjects = struct.getArray("prev_tasks");
        this.prevTasks = new ArrayList<TaskId>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.prevTasks.add(new TaskId((Struct)nestedObject, _version));
        }
        _nestedObjects = struct.getArray("standby_tasks");
        this.standbyTasks = new ArrayList<TaskId>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.standbyTasks.add(new TaskId((Struct)nestedObject, _version));
        }
        this.userEndPoint = _version >= 2 ? struct.getByteArray("user_end_point") : Bytes.EMPTY;
    }

    public Struct toStruct(short _version) {
        Object _taggedFields = null;
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("version", (Object)this.version);
        if (_version >= 3) {
            struct.set("latest_supported_version", (Object)this.latestSupportedVersion);
        } else if (this.latestSupportedVersion != -1) {
            throw new UnsupportedVersionException("Attempted to write a non-default latestSupportedVersion at version " + _version);
        }
        struct.set("process_id", (Object)this.processId);
        Struct[] _nestedObjects = new Struct[this.prevTasks.size()];
        int i = 0;
        for (TaskId element : this.prevTasks) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("prev_tasks", (Object)_nestedObjects);
        _nestedObjects = new Struct[this.standbyTasks.size()];
        i = 0;
        for (TaskId element : this.standbyTasks) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("standby_tasks", (Object)_nestedObjects);
        if (_version >= 2) {
            struct.setByteArray("user_end_point", this.userEndPoint);
        } else if (this.userEndPoint.length != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default userEndPoint at version " + _version);
        }
        return struct;
    }

    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        _size += 4;
        if (_version >= 3) {
            _size += 4;
        }
        _size += 16;
        int _arraySize = 0;
        _arraySize += 4;
        for (TaskId prevTasksElement : this.prevTasks) {
            _arraySize += prevTasksElement.size(_cache, _version);
        }
        _size += _arraySize;
        _arraySize = 0;
        _arraySize += 4;
        for (TaskId standbyTasksElement : this.standbyTasks) {
            _arraySize += standbyTasksElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (_version >= 2) {
            int _bytesSize = this.userEndPoint.length;
            _size += (_bytesSize += 4);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                _size += _field.size();
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SubscriptionInfoData)) {
            return false;
        }
        SubscriptionInfoData other = (SubscriptionInfoData)obj;
        if (this.version != other.version) {
            return false;
        }
        if (this.latestSupportedVersion != other.latestSupportedVersion) {
            return false;
        }
        if (!this.processId.equals(other.processId)) {
            return false;
        }
        if (this.prevTasks == null ? other.prevTasks != null : !this.prevTasks.equals(other.prevTasks)) {
            return false;
        }
        if (this.standbyTasks == null ? other.standbyTasks != null : !this.standbyTasks.equals(other.standbyTasks)) {
            return false;
        }
        return Arrays.equals(this.userEndPoint, other.userEndPoint);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.version;
        hashCode = 31 * hashCode + this.latestSupportedVersion;
        hashCode = 31 * hashCode + this.processId.hashCode();
        hashCode = 31 * hashCode + (this.prevTasks == null ? 0 : this.prevTasks.hashCode());
        hashCode = 31 * hashCode + (this.standbyTasks == null ? 0 : this.standbyTasks.hashCode());
        hashCode = 31 * hashCode + Arrays.hashCode(this.userEndPoint);
        return hashCode;
    }

    public String toString() {
        return "SubscriptionInfoData(version=" + this.version + ", latestSupportedVersion=" + this.latestSupportedVersion + ", prevTasks=" + MessageUtil.deepToString(this.prevTasks.iterator()) + ", standbyTasks=" + MessageUtil.deepToString(this.standbyTasks.iterator()) + ", userEndPoint=" + Arrays.toString(this.userEndPoint) + ")";
    }

    public int version() {
        return this.version;
    }

    public int latestSupportedVersion() {
        return this.latestSupportedVersion;
    }

    public UUID processId() {
        return this.processId;
    }

    public List<TaskId> prevTasks() {
        return this.prevTasks;
    }

    public List<TaskId> standbyTasks() {
        return this.standbyTasks;
    }

    public byte[] userEndPoint() {
        return this.userEndPoint;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public SubscriptionInfoData setVersion(int v) {
        this.version = v;
        return this;
    }

    public SubscriptionInfoData setLatestSupportedVersion(int v) {
        this.latestSupportedVersion = v;
        return this;
    }

    public SubscriptionInfoData setProcessId(UUID v) {
        this.processId = v;
        return this;
    }

    public SubscriptionInfoData setPrevTasks(List<TaskId> v) {
        this.prevTasks = v;
        return this;
    }

    public SubscriptionInfoData setStandbyTasks(List<TaskId> v) {
        this.standbyTasks = v;
        return this;
    }

    public SubscriptionInfoData setUserEndPoint(byte[] v) {
        this.userEndPoint = v;
        return this;
    }

    static {
        SCHEMA_6 = SCHEMA_5 = (SCHEMA_4 = (SCHEMA_3 = new Schema(new Field[]{new Field("version", (Type)Type.INT32, ""), new Field("latest_supported_version", (Type)Type.INT32, ""), new Field("process_id", (Type)Type.UUID, ""), new Field("prev_tasks", (Type)new ArrayOf((Type)TaskId.SCHEMA_1), ""), new Field("standby_tasks", (Type)new ArrayOf((Type)TaskId.SCHEMA_1), ""), new Field("user_end_point", (Type)Type.BYTES, "")})));
        SCHEMAS = new Schema[]{null, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6};
    }

    public static class TaskId
    implements Message {
        private int topicGroupId;
        private int partition;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema[] SCHEMAS;

        public TaskId(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public TaskId(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public TaskId() {
            this.topicGroupId = 0;
            this.partition = 0;
        }

        public short lowestSupportedVersion() {
            return 1;
        }

        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        public void read(Readable _readable, short _version) {
            this.topicGroupId = _readable.readInt();
            this.partition = _readable.readInt();
            this._unknownTaggedFields = null;
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.topicGroupId);
            _writable.writeInt(this.partition);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void fromStruct(Struct struct, short _version) {
            this._unknownTaggedFields = null;
            this.topicGroupId = struct.getInt("topic_group_id");
            this.partition = struct.getInt("partition");
        }

        public Struct toStruct(short _version) {
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("topic_group_id", (Object)this.topicGroupId);
            struct.set("partition", (Object)this.partition);
            return struct;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            _size += 4;
            _size += 4;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TaskId)) {
                return false;
            }
            TaskId other = (TaskId)obj;
            if (this.topicGroupId != other.topicGroupId) {
                return false;
            }
            return this.partition == other.partition;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.topicGroupId;
            hashCode = 31 * hashCode + this.partition;
            return hashCode;
        }

        public String toString() {
            return "TaskId(topicGroupId=" + this.topicGroupId + ", partition=" + this.partition + ")";
        }

        public int topicGroupId() {
            return this.topicGroupId;
        }

        public int partition() {
            return this.partition;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TaskId setTopicGroupId(int v) {
            this.topicGroupId = v;
            return this;
        }

        public TaskId setPartition(int v) {
            this.partition = v;
            return this;
        }

        static {
            SCHEMA_6 = SCHEMA_5 = (SCHEMA_4 = (SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = new Schema(new Field[]{new Field("topic_group_id", (Type)Type.INT32, ""), new Field("partition", (Type)Type.INT32, "")})))));
            SCHEMAS = new Schema[]{null, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6};
        }
    }
}

