/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.foreignkeyjoin;

import java.nio.ByteBuffer;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.SubscriptionWrapper;

public class SubscriptionWrapperSerde<K>
implements Serde<SubscriptionWrapper<K>> {
    private final SubscriptionWrapperSerializer<K> serializer;
    private final SubscriptionWrapperDeserializer<K> deserializer;

    public SubscriptionWrapperSerde(Serde<K> primaryKeySerde) {
        this.serializer = new SubscriptionWrapperSerializer(primaryKeySerde.serializer());
        this.deserializer = new SubscriptionWrapperDeserializer(primaryKeySerde.deserializer());
    }

    public Serializer<SubscriptionWrapper<K>> serializer() {
        return this.serializer;
    }

    public Deserializer<SubscriptionWrapper<K>> deserializer() {
        return this.deserializer;
    }

    private static class SubscriptionWrapperDeserializer<K>
    implements Deserializer<SubscriptionWrapper<K>> {
        private final Deserializer<K> primaryKeyDeserializer;

        SubscriptionWrapperDeserializer(Deserializer<K> primaryKeyDeserializer) {
            this.primaryKeyDeserializer = primaryKeyDeserializer;
        }

        public SubscriptionWrapper<K> deserialize(String topic, byte[] data) {
            long[] hash;
            ByteBuffer buf = ByteBuffer.wrap(data);
            byte versionAndIsHashNull = buf.get();
            byte version = (byte)(0x7F & versionAndIsHashNull);
            boolean isHashNull = (0x80 & versionAndIsHashNull) == 128;
            SubscriptionWrapper.Instruction inst = SubscriptionWrapper.Instruction.fromValue(buf.get());
            int lengthSum = 2;
            if (isHashNull) {
                hash = null;
            } else {
                hash = new long[]{buf.getLong(), buf.getLong()};
                lengthSum += 16;
            }
            byte[] primaryKeyRaw = new byte[data.length - lengthSum];
            buf.get(primaryKeyRaw, 0, primaryKeyRaw.length);
            Object primaryKey = this.primaryKeyDeserializer.deserialize(topic, primaryKeyRaw);
            return new SubscriptionWrapper<Object>(hash, inst, primaryKey, version);
        }
    }

    private static class SubscriptionWrapperSerializer<K>
    implements Serializer<SubscriptionWrapper<K>> {
        private final Serializer<K> primaryKeySerializer;

        SubscriptionWrapperSerializer(Serializer<K> primaryKeySerializer) {
            this.primaryKeySerializer = primaryKeySerializer;
        }

        public byte[] serialize(String topic, SubscriptionWrapper<K> data) {
            ByteBuffer buf;
            if (Byte.compare((byte)127, data.getVersion()) < 0) {
                throw new UnsupportedVersionException("SubscriptionWrapper version is larger than maximum supported 0x7F");
            }
            byte[] primaryKeySerializedData = this.primaryKeySerializer.serialize(topic, data.getPrimaryKey());
            if (data.getHash() != null) {
                buf = ByteBuffer.allocate(18 + primaryKeySerializedData.length);
                buf.put(data.getVersion());
            } else {
                buf = ByteBuffer.allocate(2 + primaryKeySerializedData.length);
                buf.put((byte)(data.getVersion() | 0xFFFFFF80));
            }
            buf.put(data.getInstruction().getValue());
            long[] elem = data.getHash();
            if (data.getHash() != null) {
                buf.putLong(elem[0]);
                buf.putLong(elem[1]);
            }
            buf.put(primaryKeySerializedData);
            return buf.array();
        }
    }
}

