/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.internals.AbstractMergedSortedCacheStoreIterator;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.PeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.SegmentedCacheFunction;
import org.apache.kafka.streams.state.internals.SessionKeySchema;

class MergedSortedCacheSessionStoreIterator
extends AbstractMergedSortedCacheStoreIterator<Windowed<Bytes>, Windowed<Bytes>, byte[], byte[]> {
    private final SegmentedCacheFunction cacheFunction;

    MergedSortedCacheSessionStoreIterator(PeekingKeyValueIterator<Bytes, LRUCacheEntry> cacheIterator, KeyValueIterator<Windowed<Bytes>, byte[]> storeIterator, SegmentedCacheFunction cacheFunction) {
        super(cacheIterator, storeIterator);
        this.cacheFunction = cacheFunction;
    }

    @Override
    public KeyValue<Windowed<Bytes>, byte[]> deserializeStorePair(KeyValue<Windowed<Bytes>, byte[]> pair) {
        return pair;
    }

    @Override
    Windowed<Bytes> deserializeCacheKey(Bytes cacheKey) {
        byte[] binaryKey = this.cacheFunction.key(cacheKey).get();
        byte[] keyBytes = SessionKeySchema.extractKeyBytes(binaryKey);
        Window window = SessionKeySchema.extractWindow(binaryKey);
        return new Windowed<Bytes>(Bytes.wrap((byte[])keyBytes), window);
    }

    @Override
    byte[] deserializeCacheValue(LRUCacheEntry cacheEntry) {
        return cacheEntry.value();
    }

    @Override
    public Windowed<Bytes> deserializeStoreKey(Windowed<Bytes> key) {
        return key;
    }

    @Override
    public int compare(Bytes cacheKey, Windowed<Bytes> storeKey) {
        Bytes storeKeyBytes = Bytes.wrap((byte[])SessionKeySchema.toBinary(storeKey));
        return this.cacheFunction.compareSegmentedKeys(cacheKey, storeKeyBytes);
    }
}

