/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Arrays;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.internals.BaseJoinProcessorNode;
import org.apache.kafka.streams.kstream.internals.ProcessorParameters;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;

class KTableKTableJoinNode<K, V1, V2, VR>
extends BaseJoinProcessorNode<K, V1, V2, VR> {
    private final String[] joinThisStoreNames;
    private final String[] joinOtherStoreNames;

    KTableKTableJoinNode(String parentProcessorNodeName, String processorNodeName, ValueJoiner<? super V1, ? super V2, ? extends VR> valueJoiner, ProcessorParameters<K, V1> joinThisProcessorParameters, ProcessorParameters<K, V2> joinOtherProcessorParameters, ProcessorParameters<K, VR> joinMergeProcessorParameters, String thisJoinSide, String otherJoinSide, String[] joinThisStoreNames, String[] joinOtherStoreNames) {
        super(parentProcessorNodeName, processorNodeName, valueJoiner, joinThisProcessorParameters, joinOtherProcessorParameters, joinMergeProcessorParameters, thisJoinSide, otherJoinSide);
        this.joinThisStoreNames = joinThisStoreNames;
        this.joinOtherStoreNames = joinOtherStoreNames;
    }

    String[] joinThisStoreNames() {
        return Arrays.copyOf(this.joinThisStoreNames, this.joinThisStoreNames.length);
    }

    String[] joinOtherStoreNames() {
        return Arrays.copyOf(this.joinOtherStoreNames, this.joinOtherStoreNames.length);
    }

    @Override
    void writeToTopology(InternalTopologyBuilder topologyBuilder) {
    }

    static <K, V, V1, V2, VR> KTableKTableJoinNodeBuilder<K, V1, V2, VR> kTableKTableJoinNodeBuilder() {
        return new KTableKTableJoinNodeBuilder();
    }

    static final class KTableKTableJoinNodeBuilder<K, V1, V2, VR> {
        private String processorNodeName;
        private String parentProcessorNodeName;
        private String[] joinThisStoreNames;
        private ProcessorParameters<K, V1> joinThisProcessorParameters;
        private String[] joinOtherStoreNames;
        private ProcessorParameters<K, V2> joinOtherProcessorParameters;
        private ProcessorParameters<K, VR> joinMergeProcessorParameters;
        private ValueJoiner<? super V1, ? super V2, ? extends VR> valueJoiner;
        private String thisJoinSide;
        private String otherJoinSide;

        private KTableKTableJoinNodeBuilder() {
        }

        KTableKTableJoinNodeBuilder<K, V1, V2, VR> withJoinThisStoreNames(String[] joinThisStoreNames) {
            this.joinThisStoreNames = joinThisStoreNames;
            return this;
        }

        KTableKTableJoinNodeBuilder<K, V1, V2, VR> withJoinThisProcessorParameters(ProcessorParameters<K, V1> joinThisProcessorParameters) {
            this.joinThisProcessorParameters = joinThisProcessorParameters;
            return this;
        }

        KTableKTableJoinNodeBuilder<K, V1, V2, VR> withProcessorNodeName(String processorNodeName) {
            this.processorNodeName = processorNodeName;
            return this;
        }

        KTableKTableJoinNodeBuilder<K, V1, V2, VR> withJoinOtherStoreNames(String[] joinOtherStoreNames) {
            this.joinOtherStoreNames = joinOtherStoreNames;
            return this;
        }

        KTableKTableJoinNodeBuilder<K, V1, V2, VR> withParentProcessorNodeName(String parentProcessorNodeName) {
            this.parentProcessorNodeName = parentProcessorNodeName;
            return this;
        }

        KTableKTableJoinNodeBuilder<K, V1, V2, VR> withJoinOtherProcessorParameters(ProcessorParameters<K, V2> joinOtherProcessorParameters) {
            this.joinOtherProcessorParameters = joinOtherProcessorParameters;
            return this;
        }

        KTableKTableJoinNodeBuilder<K, V1, V2, VR> withJoinMergeProcessorParameters(ProcessorParameters<K, VR> joinMergeProcessorParameters) {
            this.joinMergeProcessorParameters = joinMergeProcessorParameters;
            return this;
        }

        KTableKTableJoinNodeBuilder<K, V1, V2, VR> withValueJoiner(ValueJoiner<? super V1, ? super V2, ? extends VR> valueJoiner) {
            this.valueJoiner = valueJoiner;
            return this;
        }

        KTableKTableJoinNodeBuilder<K, V1, V2, VR> withThisJoinSide(String thisJoinSide) {
            this.thisJoinSide = thisJoinSide;
            return this;
        }

        KTableKTableJoinNodeBuilder<K, V1, V2, VR> withOtherJoinSide(String otherJoinSide) {
            this.otherJoinSide = otherJoinSide;
            return this;
        }

        KTableKTableJoinNode<K, V1, V2, VR> build() {
            return new KTableKTableJoinNode<K, V1, V2, VR>(this.parentProcessorNodeName, this.processorNodeName, this.valueJoiner, this.joinThisProcessorParameters, this.joinOtherProcessorParameters, this.joinMergeProcessorParameters, this.thisJoinSide, this.otherJoinSide, this.joinThisStoreNames, this.joinOtherStoreNames);
        }
    }
}

