/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorSupplier;

class KStreamPeek<K, V>
implements ProcessorSupplier<K, V> {
    private final boolean forwardDownStream;
    private final ForeachAction<K, V> action;

    public KStreamPeek(ForeachAction<K, V> action, boolean forwardDownStream) {
        this.action = action;
        this.forwardDownStream = forwardDownStream;
    }

    @Override
    public Processor<K, V> get() {
        return new KStreamPeekProcessor();
    }

    private class KStreamPeekProcessor
    extends AbstractProcessor<K, V> {
        private KStreamPeekProcessor() {
        }

        @Override
        public void process(K key, V value) {
            KStreamPeek.this.action.apply(key, value);
            if (KStreamPeek.this.forwardDownStream) {
                this.context().forward(key, value);
            }
        }
    }
}

