/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.state.internals.SessionKeySchema;

public class SessionWindowedDeserializer<T>
implements Deserializer<Windowed<T>> {
    private Deserializer<T> inner;

    public SessionWindowedDeserializer() {
    }

    public SessionWindowedDeserializer(Deserializer<T> inner) {
        this.inner = inner;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        if (this.inner == null) {
            String propertyName = isKey ? "default.windowed.key.serde.inner" : "default.windowed.value.serde.inner";
            String value = (String)configs.get(propertyName);
            try {
                this.inner = ((Serde)Serde.class.cast(Utils.newInstance((String)value, Serde.class))).deserializer();
                this.inner.configure(configs, isKey);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigException(propertyName, (Object)value, "Serde class " + value + " could not be found.");
            }
        }
    }

    public Windowed<T> deserialize(String topic, byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        return SessionKeySchema.from(data, this.inner, topic);
    }

    public void close() {
        this.inner.close();
    }

    Deserializer<T> innerDeserializer() {
        return this.inner;
    }
}

