/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.KGroupedTable;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.kstream.Serialized;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.kstream.ValueMapperWithKey;
import org.apache.kafka.streams.kstream.ValueTransformerWithKeySupplier;
import org.apache.kafka.streams.state.KeyValueStore;

@InterfaceStability.Evolving
public interface KTable<K, V> {
    public KTable<K, V> filter(Predicate<? super K, ? super V> var1);

    public KTable<K, V> filter(Predicate<? super K, ? super V> var1, Materialized<K, V, KeyValueStore<Bytes, byte[]>> var2);

    public KTable<K, V> filterNot(Predicate<? super K, ? super V> var1);

    public KTable<K, V> filterNot(Predicate<? super K, ? super V> var1, Materialized<K, V, KeyValueStore<Bytes, byte[]>> var2);

    public <VR> KTable<K, VR> mapValues(ValueMapper<? super V, ? extends VR> var1);

    public <VR> KTable<K, VR> mapValues(ValueMapperWithKey<? super K, ? super V, ? extends VR> var1);

    public <VR> KTable<K, VR> mapValues(ValueMapper<? super V, ? extends VR> var1, Materialized<K, VR, KeyValueStore<Bytes, byte[]>> var2);

    public <VR> KTable<K, VR> mapValues(ValueMapperWithKey<? super K, ? super V, ? extends VR> var1, Materialized<K, VR, KeyValueStore<Bytes, byte[]>> var2);

    public KStream<K, V> toStream();

    public <KR> KStream<KR, V> toStream(KeyValueMapper<? super K, ? super V, ? extends KR> var1);

    public <VR> KTable<K, VR> transformValues(ValueTransformerWithKeySupplier<? super K, ? super V, ? extends VR> var1, String ... var2);

    public <VR> KTable<K, VR> transformValues(ValueTransformerWithKeySupplier<? super K, ? super V, ? extends VR> var1, Materialized<K, VR, KeyValueStore<Bytes, byte[]>> var2, String ... var3);

    public <KR, VR> KGroupedTable<KR, VR> groupBy(KeyValueMapper<? super K, ? super V, KeyValue<KR, VR>> var1);

    public <KR, VR> KGroupedTable<KR, VR> groupBy(KeyValueMapper<? super K, ? super V, KeyValue<KR, VR>> var1, Serialized<KR, VR> var2);

    public <VO, VR> KTable<K, VR> join(KTable<K, VO> var1, ValueJoiner<? super V, ? super VO, ? extends VR> var2);

    public <VO, VR> KTable<K, VR> join(KTable<K, VO> var1, ValueJoiner<? super V, ? super VO, ? extends VR> var2, Materialized<K, VR, KeyValueStore<Bytes, byte[]>> var3);

    public <VO, VR> KTable<K, VR> leftJoin(KTable<K, VO> var1, ValueJoiner<? super V, ? super VO, ? extends VR> var2);

    public <VO, VR> KTable<K, VR> leftJoin(KTable<K, VO> var1, ValueJoiner<? super V, ? super VO, ? extends VR> var2, Materialized<K, VR, KeyValueStore<Bytes, byte[]>> var3);

    public <VO, VR> KTable<K, VR> outerJoin(KTable<K, VO> var1, ValueJoiner<? super V, ? super VO, ? extends VR> var2);

    public <VO, VR> KTable<K, VR> outerJoin(KTable<K, VO> var1, ValueJoiner<? super V, ? super VO, ? extends VR> var2, Materialized<K, VR, KeyValueStore<Bytes, byte[]>> var3);

    public String queryableStoreName();
}

