/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.internals;

import java.util.List;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.internals.ReadOnlyKeyValueStoreFacade;

public class KeyValueStoreFacade<K, V>
extends ReadOnlyKeyValueStoreFacade<K, V>
implements KeyValueStore<K, V> {
    public KeyValueStoreFacade(TimestampedKeyValueStore<K, V> inner) {
        super(inner);
    }

    @Deprecated
    public void init(ProcessorContext context, StateStore root) {
        this.inner.init(context, root);
    }

    public void init(StateStoreContext context, StateStore root) {
        this.inner.init(context, root);
    }

    public void put(K key, V value) {
        this.inner.put(key, (Object)ValueAndTimestamp.make(value, (long)-1L));
    }

    public V putIfAbsent(K key, V value) {
        return (V)ValueAndTimestamp.getValueOrNull((ValueAndTimestamp)((ValueAndTimestamp)this.inner.putIfAbsent(key, (Object)ValueAndTimestamp.make(value, (long)-1L))));
    }

    public void putAll(List<KeyValue<K, V>> entries) {
        for (KeyValue<K, V> entry : entries) {
            this.inner.put(entry.key, (Object)ValueAndTimestamp.make((Object)entry.value, (long)-1L));
        }
    }

    public V delete(K key) {
        return (V)ValueAndTimestamp.getValueOrNull((ValueAndTimestamp)((ValueAndTimestamp)this.inner.delete(key)));
    }

    public void flush() {
        this.inner.flush();
    }

    public void close() {
        this.inner.close();
    }

    public String name() {
        return this.inner.name();
    }

    public boolean persistent() {
        return this.inner.persistent();
    }

    public boolean isOpen() {
        return this.inner.isOpen();
    }
}

