/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.storage.internals.log.OffsetMap;

public class SkimpyOffsetMap
implements OffsetMap {
    private final int memory;
    public final int bytesPerEntry;
    private final ByteBuffer bytes;
    private final MessageDigest digest;
    private final int hashSize;
    private final int slots;
    private final byte[] hash1;
    private final byte[] hash2;
    private int entries = 0;
    private long lookups = 0L;
    private long probes = 0L;
    private long lastOffset = -1L;

    public SkimpyOffsetMap(int memory) throws NoSuchAlgorithmException {
        this(memory, "MD5");
    }

    public SkimpyOffsetMap(int memory, String hashAlgorithm) throws NoSuchAlgorithmException {
        this.memory = memory;
        this.bytes = ByteBuffer.allocate(memory);
        this.digest = MessageDigest.getInstance(hashAlgorithm);
        this.hashSize = this.digest.getDigestLength();
        this.bytesPerEntry = this.hashSize + 8;
        this.slots = memory / this.bytesPerEntry;
        this.hash1 = new byte[this.hashSize];
        this.hash2 = new byte[this.hashSize];
    }

    @Override
    public int slots() {
        return this.slots;
    }

    @Override
    public long get(ByteBuffer key) throws DigestException {
        ++this.lookups;
        this.hashInto(key, this.hash1);
        int attempt = 0;
        int pos = 0;
        int maxAttempts = this.slots + this.hashSize - 4;
        do {
            if (attempt >= maxAttempts) {
                return -1L;
            }
            pos = this.positionOf(this.hash1, attempt);
            this.bytes.position(pos);
            if (this.isEmpty(pos)) {
                return -1L;
            }
            this.bytes.get(this.hash2);
            ++attempt;
        } while (!Arrays.equals(this.hash1, this.hash2));
        return this.bytes.getLong();
    }

    @Override
    public void put(ByteBuffer key, long offset) throws DigestException {
        if (this.entries >= this.slots) {
            throw new IllegalArgumentException("Attempted to add a new entry to a full offset map, entries: " + this.entries + ", slots: " + this.slots);
        }
        ++this.lookups;
        this.hashInto(key, this.hash1);
        int attempt = 0;
        int pos = this.positionOf(this.hash1, attempt);
        while (!this.isEmpty(pos)) {
            this.bytes.position(pos);
            this.bytes.get(this.hash2);
            if (Arrays.equals(this.hash1, this.hash2)) {
                this.bytes.putLong(offset);
                this.lastOffset = offset;
                return;
            }
            pos = this.positionOf(this.hash1, ++attempt);
        }
        this.bytes.position(pos);
        this.bytes.put(this.hash1);
        this.bytes.putLong(offset);
        this.lastOffset = offset;
        ++this.entries;
    }

    @Override
    public void put(ByteBuffer key, long offset, boolean isTombstone) throws DigestException {
        this.put(key, offset);
    }

    @Override
    public void updateLatestOffset(long offset) {
        this.lastOffset = offset;
    }

    @Override
    public void clear() {
        this.entries = 0;
        this.lookups = 0L;
        this.probes = 0L;
        this.lastOffset = -1L;
        Arrays.fill(this.bytes.array(), this.bytes.arrayOffset(), this.bytes.arrayOffset() + this.bytes.limit(), (byte)0);
    }

    @Override
    public int size() {
        return this.entries;
    }

    @Override
    public long latestOffset() {
        return this.lastOffset;
    }

    @Override
    public int memory() {
        return this.memory;
    }

    public double collisionRate() {
        return (double)(this.probes - this.lookups) / (double)this.lookups;
    }

    private boolean isEmpty(int position) {
        return this.bytes.getLong(position) == 0L && this.bytes.getLong(position + 8) == 0L && this.bytes.getLong(position + 16) == 0L;
    }

    private int positionOf(byte[] hash, int attempt) {
        int probe = ByteUtils.readIntBE((byte[])hash, (int)Math.min(attempt, this.hashSize - 4)) + Math.max(0, attempt - this.hashSize + 4);
        int slot = Utils.abs((int)probe) % this.slots;
        ++this.probes;
        return slot * this.bytesPerEntry;
    }

    private void hashInto(ByteBuffer key, byte[] buffer) throws DigestException {
        key.mark();
        this.digest.update(key);
        key.reset();
        this.digest.digest(buffer, 0, this.hashSize);
    }
}

