/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.checksum;

import java.util.Arrays;

public enum E2EChecksumProtectedFileType {
    SEGMENT("segment"),
    OFFSET_INDEX("offset-index"),
    TIMESTAMP_INDEX("timestamp-index");

    private final String suffix;

    private E2EChecksumProtectedFileType(String suffix) {
        this.suffix = suffix;
    }

    public String suffix() {
        return this.suffix;
    }

    public static E2EChecksumProtectedFileType fromSuffix(String suffix) {
        for (E2EChecksumProtectedFileType f : E2EChecksumProtectedFileType.values()) {
            if (!f.suffix.equalsIgnoreCase(suffix)) continue;
            return f;
        }
        throw new IllegalArgumentException("No constant with value " + suffix + " found");
    }

    public static String[] getAllAsArray() {
        return (String[])Arrays.stream(E2EChecksumProtectedFileType.values()).map(E2EChecksumProtectedFileType::suffix).toArray(String[]::new);
    }
}

