/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.checkpoint;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.server.common.CheckpointFile;
import org.apache.kafka.storage.internals.checkpoint.CheckpointFileWithFailureHandler;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;

public class OffsetCheckpointFile {
    private static final Pattern WHITESPACES_PATTERN = Pattern.compile("\\s+");
    public static final int CURRENT_VERSION = 0;
    private final File file;
    private final CheckpointFileWithFailureHandler<TopicPartitionOffset> checkpoint;

    public OffsetCheckpointFile(File file, LogDirFailureChannel logDirFailureChannel) throws IOException {
        this.file = file;
        this.checkpoint = new CheckpointFileWithFailureHandler<TopicPartitionOffset>(file, 0, new Formatter(), logDirFailureChannel, file.getParent());
    }

    public void write(Map<TopicPartition, Long> offsets) {
        ArrayList list = new ArrayList(offsets.size());
        offsets.forEach((key, value) -> list.add(new TopicPartitionOffset((TopicPartition)key, (long)value)));
        this.checkpoint.write(list);
    }

    public Map<TopicPartition, Long> read() {
        List<TopicPartitionOffset> list = this.checkpoint.read();
        HashMap<TopicPartition, Long> result = new HashMap<TopicPartition, Long>(list.size());
        list.forEach(tpo -> result.put(tpo.tp, tpo.offset));
        return result;
    }

    public File file() {
        return this.file;
    }

    static class Formatter
    implements CheckpointFile.EntryFormatter<TopicPartitionOffset> {
        Formatter() {
        }

        public String toString(TopicPartitionOffset tpo) {
            TopicPartition tp = tpo.tp;
            return tp.topic() + " " + tp.partition() + " " + tpo.offset;
        }

        public Optional<TopicPartitionOffset> fromString(String line) {
            String[] parts = WHITESPACES_PATTERN.split(line);
            if (parts.length == 3) {
                return Optional.of(new TopicPartitionOffset(new TopicPartition(parts[0], Integer.parseInt(parts[1])), Long.parseLong(parts[2])));
            }
            return Optional.empty();
        }
    }

    static class TopicPartitionOffset {
        final TopicPartition tp;
        final long offset;

        TopicPartitionOffset(TopicPartition tp, long offset) {
            this.tp = tp;
            this.offset = offset;
        }
    }
}

