/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.server.config.ServerTopicConfigSynonyms;

public class CleanerConfig {
    public static final String HASH_ALGORITHM = "MD5";
    public static final int LOG_CLEANER_THREADS = 1;
    public static final double LOG_CLEANER_IO_MAX_BYTES_PER_SECOND = Double.MAX_VALUE;
    public static final long LOG_CLEANER_DEDUPE_BUFFER_SIZE = 0x8000000L;
    public static final int LOG_CLEANER_IO_BUFFER_SIZE = 524288;
    public static final double LOG_CLEANER_DEDUPE_BUFFER_LOAD_FACTOR = 0.9;
    public static final int LOG_CLEANER_BACKOFF_MS = 15000;
    public static final boolean LOG_CLEANER_ENABLE = true;
    public static final String LOG_CLEANER_THREADS_PROP = "log.cleaner.threads";
    public static final String LOG_CLEANER_IO_MAX_BYTES_PER_SECOND_PROP = "log.cleaner.io.max.bytes.per.second";
    public static final String LOG_CLEANER_DEDUPE_BUFFER_SIZE_PROP = "log.cleaner.dedupe.buffer.size";
    public static final String LOG_CLEANER_IO_BUFFER_SIZE_PROP = "log.cleaner.io.buffer.size";
    public static final String LOG_CLEANER_DEDUPE_BUFFER_LOAD_FACTOR_PROP = "log.cleaner.io.buffer.load.factor";
    public static final String LOG_CLEANER_BACKOFF_MS_PROP = "log.cleaner.backoff.ms";
    public static final String LOG_CLEANER_MIN_CLEAN_RATIO_PROP = ServerTopicConfigSynonyms.serverSynonym((String)"min.cleanable.dirty.ratio");
    public static final String LOG_CLEANER_ENABLE_PROP = "log.cleaner.enable";
    public static final String LOG_CLEANER_DELETE_RETENTION_MS_PROP = ServerTopicConfigSynonyms.serverSynonym((String)"delete.retention.ms");
    public static final String LOG_CLEANER_MIN_COMPACTION_LAG_MS_PROP = ServerTopicConfigSynonyms.serverSynonym((String)"min.compaction.lag.ms");
    public static final String LOG_CLEANER_MAX_COMPACTION_LAG_MS_PROP = ServerTopicConfigSynonyms.serverSynonym((String)"max.compaction.lag.ms");
    public static final String LOG_CLEANER_MIN_CLEAN_RATIO_DOC = "The minimum ratio of dirty log to total log for a log to eligible for cleaning. If the " + LOG_CLEANER_MAX_COMPACTION_LAG_MS_PROP + " or the " + LOG_CLEANER_MIN_COMPACTION_LAG_MS_PROP + " configurations are also specified, then the log compactor considers the log eligible for compaction as soon as either: (i) the dirty ratio threshold has been met and the log has had dirty (uncompacted) records for at least the " + LOG_CLEANER_MIN_COMPACTION_LAG_MS_PROP + " duration, or (ii) if the log has had dirty (uncompacted) records for at most the " + LOG_CLEANER_MAX_COMPACTION_LAG_MS_PROP + " period.";
    public static final String LOG_CLEANER_THREADS_DOC = "The number of background threads to use for log cleaning";
    public static final String LOG_CLEANER_IO_MAX_BYTES_PER_SECOND_DOC = "The log cleaner will be throttled so that the sum of its read and write i/o will be less than this value on average";
    public static final String LOG_CLEANER_DEDUPE_BUFFER_SIZE_DOC = "The total memory used for log deduplication across all cleaner threads";
    public static final String LOG_CLEANER_IO_BUFFER_SIZE_DOC = "The total memory used for log cleaner I/O buffers across all cleaner threads";
    public static final String LOG_CLEANER_DEDUPE_BUFFER_LOAD_FACTOR_DOC = "Log cleaner dedupe buffer load factor. The percentage full the dedupe buffer can become. A higher value will allow more log to be cleaned at once but will lead to more hash collisions";
    public static final String LOG_CLEANER_BACKOFF_MS_DOC = "The amount of time to sleep when there are no logs to clean";
    public static final String LOG_CLEANER_ENABLE_DOC = "Enable the log cleaner process to run on the server. Should be enabled if using any topics with a cleanup.policy=compact including the internal offsets topic. If disabled those topics will not be compacted and continually grow in size.";
    public static final String LOG_CLEANER_DELETE_RETENTION_MS_DOC = "The amount of time to retain tombstone message markers for log compacted topics. This setting also gives a bound on the time in which a consumer must complete a read if they begin from offset 0 to ensure that they get a valid snapshot of the final stage (otherwise  tombstones messages may be collected before a consumer completes their scan).";
    public static final String LOG_CLEANER_MIN_COMPACTION_LAG_MS_DOC = "The minimum time a message will remain uncompacted in the log. Only applicable for logs that are being compacted.";
    public static final String LOG_CLEANER_MAX_COMPACTION_LAG_MS_DOC = "The maximum time a message will remain ineligible for compaction in the log. Only applicable for logs that are being compacted.";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("log.cleaner.threads", ConfigDef.Type.INT, (Object)1, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "The number of background threads to use for log cleaning").define("log.cleaner.io.max.bytes.per.second", ConfigDef.Type.DOUBLE, (Object)Double.MAX_VALUE, ConfigDef.Importance.MEDIUM, "The log cleaner will be throttled so that the sum of its read and write i/o will be less than this value on average").define("log.cleaner.dedupe.buffer.size", ConfigDef.Type.LONG, (Object)0x8000000L, ConfigDef.Importance.MEDIUM, "The total memory used for log deduplication across all cleaner threads").define("log.cleaner.io.buffer.size", ConfigDef.Type.INT, (Object)524288, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "The total memory used for log cleaner I/O buffers across all cleaner threads").define("log.cleaner.io.buffer.load.factor", ConfigDef.Type.DOUBLE, (Object)0.9, ConfigDef.Importance.MEDIUM, "Log cleaner dedupe buffer load factor. The percentage full the dedupe buffer can become. A higher value will allow more log to be cleaned at once but will lead to more hash collisions").define("log.cleaner.backoff.ms", ConfigDef.Type.LONG, (Object)15000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "The amount of time to sleep when there are no logs to clean").define(LOG_CLEANER_MIN_CLEAN_RATIO_PROP, ConfigDef.Type.DOUBLE, (Object)0.5, (ConfigDef.Validator)ConfigDef.Range.between((Number)0, (Number)1), ConfigDef.Importance.MEDIUM, LOG_CLEANER_MIN_CLEAN_RATIO_DOC).define("log.cleaner.enable", ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.MEDIUM, "Enable the log cleaner process to run on the server. Should be enabled if using any topics with a cleanup.policy=compact including the internal offsets topic. If disabled those topics will not be compacted and continually grow in size.").define(LOG_CLEANER_DELETE_RETENTION_MS_PROP, ConfigDef.Type.LONG, (Object)86400000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "The amount of time to retain tombstone message markers for log compacted topics. This setting also gives a bound on the time in which a consumer must complete a read if they begin from offset 0 to ensure that they get a valid snapshot of the final stage (otherwise  tombstones messages may be collected before a consumer completes their scan).").define(LOG_CLEANER_MIN_COMPACTION_LAG_MS_PROP, ConfigDef.Type.LONG, (Object)0L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "The minimum time a message will remain uncompacted in the log. Only applicable for logs that are being compacted.").define(LOG_CLEANER_MAX_COMPACTION_LAG_MS_PROP, ConfigDef.Type.LONG, (Object)Long.MAX_VALUE, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The maximum time a message will remain ineligible for compaction in the log. Only applicable for logs that are being compacted.");
    public final int numThreads;
    public final long dedupeBufferSize;
    public final double dedupeBufferLoadFactor;
    public final int ioBufferSize;
    public final int maxMessageSize;
    public final double maxIoBytesPerSecond;
    public final long backoffMs;
    public final boolean enableCleaner;

    public CleanerConfig(boolean enableCleaner) {
        this(1, 0x400000L, 0.9, 0x100000, 0x2000000, Double.MAX_VALUE, 15000L, enableCleaner);
    }

    public CleanerConfig(int numThreads, long dedupeBufferSize, double dedupeBufferLoadFactor, int ioBufferSize, int maxMessageSize, double maxIoBytesPerSecond, long backoffMs, boolean enableCleaner) {
        this.numThreads = numThreads;
        this.dedupeBufferSize = dedupeBufferSize;
        this.dedupeBufferLoadFactor = dedupeBufferLoadFactor;
        this.ioBufferSize = ioBufferSize;
        this.maxMessageSize = maxMessageSize;
        this.maxIoBytesPerSecond = maxIoBytesPerSecond;
        this.backoffMs = backoffMs;
        this.enableCleaner = enableCleaner;
    }

    public String hashAlgorithm() {
        return HASH_ALGORITHM;
    }
}

