/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage.generated;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class RemoteLogSegmentMetadataSnapshotRecord
implements ApiMessage {
    Uuid segmentId;
    long startOffset;
    long endOffset;
    int brokerId;
    long maxTimestampMs;
    long eventTimestampMs;
    List<SegmentLeaderEpochEntry> segmentLeaderEpochs;
    int segmentSizeInBytes;
    byte[] customMetadata;
    byte remoteLogSegmentState;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("segment_id", (Type)Type.UUID, "Unique identifier of the log segment"), new Field("start_offset", (Type)Type.INT64, "Start offset  of the segment."), new Field("end_offset", (Type)Type.INT64, "End offset  of the segment."), new Field("broker_id", (Type)Type.INT32, "Broker (controller or leader) id from which this event is created or updated."), new Field("max_timestamp_ms", (Type)Type.INT64, "Maximum timestamp with in this segment."), new Field("event_timestamp_ms", (Type)Type.INT64, "Event timestamp of this segment."), new Field("segment_leader_epochs", (Type)new CompactArrayOf((Type)SegmentLeaderEpochEntry.SCHEMA_0), "Leader epochs of this segment."), new Field("segment_size_in_bytes", (Type)Type.INT32, "Segment size in bytes"), new Field("custom_metadata", (Type)Type.COMPACT_NULLABLE_BYTES, "Custom metadata."), new Field("remote_log_segment_state", (Type)Type.INT8, "State of the remote log segment"), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public RemoteLogSegmentMetadataSnapshotRecord(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public RemoteLogSegmentMetadataSnapshotRecord() {
        this.segmentId = Uuid.ZERO_UUID;
        this.startOffset = 0L;
        this.endOffset = 0L;
        this.brokerId = 0;
        this.maxTimestampMs = 0L;
        this.eventTimestampMs = 0L;
        this.segmentLeaderEpochs = new ArrayList<SegmentLeaderEpochEntry>(0);
        this.segmentSizeInBytes = 0;
        this.customMetadata = null;
        this.remoteLogSegmentState = 0;
    }

    public short apiKey() {
        return 3;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public void read(Readable _readable, short _version) {
        this.segmentId = _readable.readUuid();
        this.startOffset = _readable.readLong();
        this.endOffset = _readable.readLong();
        this.brokerId = _readable.readInt();
        this.maxTimestampMs = _readable.readLong();
        this.eventTimestampMs = _readable.readLong();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field segmentLeaderEpochs was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<SegmentLeaderEpochEntry> newCollection = new ArrayList<SegmentLeaderEpochEntry>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new SegmentLeaderEpochEntry(_readable, _version));
        }
        this.segmentLeaderEpochs = newCollection;
        this.segmentSizeInBytes = _readable.readInt();
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.customMetadata = null;
        } else {
            byte[] newBytes = _readable.readArray(length);
            this.customMetadata = newBytes;
        }
        this.remoteLogSegmentState = _readable.readByte();
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeUuid(this.segmentId);
        _writable.writeLong(this.startOffset);
        _writable.writeLong(this.endOffset);
        _writable.writeInt(this.brokerId);
        _writable.writeLong(this.maxTimestampMs);
        _writable.writeLong(this.eventTimestampMs);
        _writable.writeUnsignedVarint(this.segmentLeaderEpochs.size() + 1);
        for (SegmentLeaderEpochEntry segmentLeaderEpochsElement : this.segmentLeaderEpochs) {
            segmentLeaderEpochsElement.write(_writable, _cache, _version);
        }
        _writable.writeInt(this.segmentSizeInBytes);
        if (this.customMetadata == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _writable.writeUnsignedVarint(this.customMetadata.length + 1);
            _writable.writeByteArray(this.customMetadata);
        }
        _writable.writeByte(this.remoteLogSegmentState);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(16);
        _size.addBytes(8);
        _size.addBytes(8);
        _size.addBytes(4);
        _size.addBytes(8);
        _size.addBytes(8);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.segmentLeaderEpochs.size() + 1)));
        for (SegmentLeaderEpochEntry segmentLeaderEpochsElement : this.segmentLeaderEpochs) {
            segmentLeaderEpochsElement.addSize(_size, _cache, _version);
        }
        _size.addBytes(4);
        if (this.customMetadata == null) {
            _size.addBytes(1);
        } else {
            _size.addBytes(this.customMetadata.length);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.customMetadata.length + 1)));
        }
        _size.addBytes(1);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RemoteLogSegmentMetadataSnapshotRecord)) {
            return false;
        }
        RemoteLogSegmentMetadataSnapshotRecord other = (RemoteLogSegmentMetadataSnapshotRecord)obj;
        if (!this.segmentId.equals((Object)other.segmentId)) {
            return false;
        }
        if (this.startOffset != other.startOffset) {
            return false;
        }
        if (this.endOffset != other.endOffset) {
            return false;
        }
        if (this.brokerId != other.brokerId) {
            return false;
        }
        if (this.maxTimestampMs != other.maxTimestampMs) {
            return false;
        }
        if (this.eventTimestampMs != other.eventTimestampMs) {
            return false;
        }
        if (this.segmentLeaderEpochs == null ? other.segmentLeaderEpochs != null : !this.segmentLeaderEpochs.equals(other.segmentLeaderEpochs)) {
            return false;
        }
        if (this.segmentSizeInBytes != other.segmentSizeInBytes) {
            return false;
        }
        if (!Arrays.equals(this.customMetadata, other.customMetadata)) {
            return false;
        }
        if (this.remoteLogSegmentState != other.remoteLogSegmentState) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.segmentId.hashCode();
        hashCode = 31 * hashCode + ((int)(this.startOffset >> 32) ^ (int)this.startOffset);
        hashCode = 31 * hashCode + ((int)(this.endOffset >> 32) ^ (int)this.endOffset);
        hashCode = 31 * hashCode + this.brokerId;
        hashCode = 31 * hashCode + ((int)(this.maxTimestampMs >> 32) ^ (int)this.maxTimestampMs);
        hashCode = 31 * hashCode + ((int)(this.eventTimestampMs >> 32) ^ (int)this.eventTimestampMs);
        hashCode = 31 * hashCode + (this.segmentLeaderEpochs == null ? 0 : this.segmentLeaderEpochs.hashCode());
        hashCode = 31 * hashCode + this.segmentSizeInBytes;
        hashCode = 31 * hashCode + Arrays.hashCode(this.customMetadata);
        hashCode = 31 * hashCode + this.remoteLogSegmentState;
        return hashCode;
    }

    public RemoteLogSegmentMetadataSnapshotRecord duplicate() {
        RemoteLogSegmentMetadataSnapshotRecord _duplicate = new RemoteLogSegmentMetadataSnapshotRecord();
        _duplicate.segmentId = this.segmentId;
        _duplicate.startOffset = this.startOffset;
        _duplicate.endOffset = this.endOffset;
        _duplicate.brokerId = this.brokerId;
        _duplicate.maxTimestampMs = this.maxTimestampMs;
        _duplicate.eventTimestampMs = this.eventTimestampMs;
        ArrayList<SegmentLeaderEpochEntry> newSegmentLeaderEpochs = new ArrayList<SegmentLeaderEpochEntry>(this.segmentLeaderEpochs.size());
        for (SegmentLeaderEpochEntry _element : this.segmentLeaderEpochs) {
            newSegmentLeaderEpochs.add(_element.duplicate());
        }
        _duplicate.segmentLeaderEpochs = newSegmentLeaderEpochs;
        _duplicate.segmentSizeInBytes = this.segmentSizeInBytes;
        _duplicate.customMetadata = (byte[])(this.customMetadata == null ? null : MessageUtil.duplicate((byte[])this.customMetadata));
        _duplicate.remoteLogSegmentState = this.remoteLogSegmentState;
        return _duplicate;
    }

    public String toString() {
        return "RemoteLogSegmentMetadataSnapshotRecord(segmentId=" + this.segmentId.toString() + ", startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + ", brokerId=" + this.brokerId + ", maxTimestampMs=" + this.maxTimestampMs + ", eventTimestampMs=" + this.eventTimestampMs + ", segmentLeaderEpochs=" + MessageUtil.deepToString(this.segmentLeaderEpochs.iterator()) + ", segmentSizeInBytes=" + this.segmentSizeInBytes + ", customMetadata=" + Arrays.toString(this.customMetadata) + ", remoteLogSegmentState=" + this.remoteLogSegmentState + ")";
    }

    public Uuid segmentId() {
        return this.segmentId;
    }

    public long startOffset() {
        return this.startOffset;
    }

    public long endOffset() {
        return this.endOffset;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public long maxTimestampMs() {
        return this.maxTimestampMs;
    }

    public long eventTimestampMs() {
        return this.eventTimestampMs;
    }

    public List<SegmentLeaderEpochEntry> segmentLeaderEpochs() {
        return this.segmentLeaderEpochs;
    }

    public int segmentSizeInBytes() {
        return this.segmentSizeInBytes;
    }

    public byte[] customMetadata() {
        return this.customMetadata;
    }

    public byte remoteLogSegmentState() {
        return this.remoteLogSegmentState;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public RemoteLogSegmentMetadataSnapshotRecord setSegmentId(Uuid v) {
        this.segmentId = v;
        return this;
    }

    public RemoteLogSegmentMetadataSnapshotRecord setStartOffset(long v) {
        this.startOffset = v;
        return this;
    }

    public RemoteLogSegmentMetadataSnapshotRecord setEndOffset(long v) {
        this.endOffset = v;
        return this;
    }

    public RemoteLogSegmentMetadataSnapshotRecord setBrokerId(int v) {
        this.brokerId = v;
        return this;
    }

    public RemoteLogSegmentMetadataSnapshotRecord setMaxTimestampMs(long v) {
        this.maxTimestampMs = v;
        return this;
    }

    public RemoteLogSegmentMetadataSnapshotRecord setEventTimestampMs(long v) {
        this.eventTimestampMs = v;
        return this;
    }

    public RemoteLogSegmentMetadataSnapshotRecord setSegmentLeaderEpochs(List<SegmentLeaderEpochEntry> v) {
        this.segmentLeaderEpochs = v;
        return this;
    }

    public RemoteLogSegmentMetadataSnapshotRecord setSegmentSizeInBytes(int v) {
        this.segmentSizeInBytes = v;
        return this;
    }

    public RemoteLogSegmentMetadataSnapshotRecord setCustomMetadata(byte[] v) {
        this.customMetadata = v;
        return this;
    }

    public RemoteLogSegmentMetadataSnapshotRecord setRemoteLogSegmentState(byte v) {
        this.remoteLogSegmentState = v;
        return this;
    }

    public static class SegmentLeaderEpochEntry
    implements Message {
        int leaderEpoch;
        long offset;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("leader_epoch", (Type)Type.INT32, "Leader epoch"), new Field("offset", (Type)Type.INT64, "Start offset for the leader epoch"), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public SegmentLeaderEpochEntry(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public SegmentLeaderEpochEntry() {
            this.leaderEpoch = 0;
            this.offset = 0L;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of SegmentLeaderEpochEntry");
            }
            this.leaderEpoch = _readable.readInt();
            this.offset = _readable.readLong();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.leaderEpoch);
            _writable.writeLong(this.offset);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of SegmentLeaderEpochEntry");
            }
            _size.addBytes(4);
            _size.addBytes(8);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SegmentLeaderEpochEntry)) {
                return false;
            }
            SegmentLeaderEpochEntry other = (SegmentLeaderEpochEntry)obj;
            if (this.leaderEpoch != other.leaderEpoch) {
                return false;
            }
            if (this.offset != other.offset) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.leaderEpoch;
            hashCode = 31 * hashCode + ((int)(this.offset >> 32) ^ (int)this.offset);
            return hashCode;
        }

        public SegmentLeaderEpochEntry duplicate() {
            SegmentLeaderEpochEntry _duplicate = new SegmentLeaderEpochEntry();
            _duplicate.leaderEpoch = this.leaderEpoch;
            _duplicate.offset = this.offset;
            return _duplicate;
        }

        public String toString() {
            return "SegmentLeaderEpochEntry(leaderEpoch=" + this.leaderEpoch + ", offset=" + this.offset + ")";
        }

        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        public long offset() {
            return this.offset;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public SegmentLeaderEpochEntry setLeaderEpoch(int v) {
            this.leaderEpoch = v;
            return this;
        }

        public SegmentLeaderEpochEntry setOffset(long v) {
            this.offset = v;
            return this;
        }
    }
}

