/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.link;

import java.util.Locale;
import org.apache.kafka.common.errors.InvalidConfigurationException;

public class ClusterLinkConfig {
    public static final String LINK_MODE_PROP = "link.mode";
    public static final String CONNECTION_MODE_PROP = "connection.mode";
    public static final String LINK_PREFIX = "cluster.link.prefix";

    public static enum LinkMode {
        DESTINATION(false, true),
        SOURCE(true, false),
        BIDIRECTIONAL(true, true);

        private final boolean mayActAsSource;
        private final boolean mayActAsDestination;
        private final String lowerCaseName;

        private LinkMode(boolean mayActAsSource, boolean mayActAsDestination) {
            this.mayActAsSource = mayActAsSource;
            this.mayActAsDestination = mayActAsDestination;
            this.lowerCaseName = this.name().toLowerCase(Locale.ROOT);
        }

        public boolean mayActAsSource() {
            return this.mayActAsSource;
        }

        public boolean mayActAsDestination() {
            return this.mayActAsDestination;
        }

        public String lowerCaseName() {
            return this.lowerCaseName;
        }

        public static LinkMode fromString(String linkModeStr) {
            for (LinkMode mode : LinkMode.values()) {
                if (!linkModeStr.equalsIgnoreCase(mode.toString())) continue;
                return mode;
            }
            throw new InvalidConfigurationException("Unknown link mode " + linkModeStr + " provided in the cluster link configuration");
        }
    }
}

