/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.record;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.record.CompressionType;

public enum BrokerCompressionType {
    UNCOMPRESSED("uncompressed"),
    ZSTD("zstd"),
    LZ4("lz4"),
    SNAPPY("snappy"),
    GZIP("gzip"),
    PRODUCER("producer");

    private static final List<BrokerCompressionType> VALUES;
    public final String name;

    private BrokerCompressionType(String name) {
        this.name = name;
    }

    public static Compression targetCompression(Optional<Compression> logCompression, CompressionType producerCompressionType) {
        return logCompression.orElseGet(() -> Compression.of((CompressionType)producerCompressionType).build());
    }

    public static List<String> names() {
        return VALUES.stream().map(v -> v.name).collect(Collectors.toList());
    }

    public static BrokerCompressionType forName(String n) {
        String name = n.toLowerCase(Locale.ROOT);
        return VALUES.stream().filter(v -> v.name.equals(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown broker compression type name: " + name));
    }

    static {
        VALUES = List.of(BrokerCompressionType.values());
    }
}

