/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util;

import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.ShutdownableThread;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class ShutdownableThreadTest {
    @AfterEach
    public void tearDown() {
        Exit.resetExitProcedure();
    }

    @Test
    public void testShutdownWhenCalledAfterThreadStart() throws InterruptedException {
        AtomicReference statusCodeOption = new AtomicReference(Optional.empty());
        Exit.setExitProcedure((statusCode, ignored) -> {
            statusCodeOption.set(Optional.of(statusCode));
            Utils.sleep((long)Long.MAX_VALUE);
            throw new AssertionError();
        });
        final CountDownLatch latch = new CountDownLatch(1);
        ShutdownableThread thread = new ShutdownableThread("shutdownable-thread-test"){

            public void doWork() {
                latch.countDown();
                throw new FatalExitError();
            }
        };
        thread.start();
        Assertions.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS), (String)"doWork was not invoked");
        thread.shutdown();
        TestUtils.waitForCondition(() -> ((Optional)statusCodeOption.get()).isPresent(), (String)"Status code was not set by exit procedure");
        Assertions.assertEquals((int)1, (Integer)((Integer)statusCodeOption.get().get()));
    }

    @Test
    public void testIsThreadStarted() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        ShutdownableThread thread = new ShutdownableThread("shutdownable-thread-test"){

            public void doWork() {
                latch.countDown();
            }
        };
        Assertions.assertFalse((boolean)thread.isStarted());
        thread.start();
        Assertions.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS), (String)"doWork was not invoked");
        Assertions.assertTrue((boolean)thread.isStarted());
        thread.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testShutdownWhenTestTimesOut(final boolean isInterruptible) {
        Exit.setExitProcedure((statusCode, ignored) -> {
            throw new FatalExitError();
        });
        final CountDownLatch afterTest = new CountDownLatch(1);
        try {
            final CountDownLatch startupLatch = new CountDownLatch(1);
            ShutdownableThread thread = new ShutdownableThread("shutdownable-thread-timeout", isInterruptible){

                public void doWork() {
                    startupLatch.countDown();
                    if (isInterruptible) {
                        try {
                            afterTest.await();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    try {
                        afterTest.await();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    throw new FatalExitError();
                }
            };
            thread.start();
            startupLatch.await();
            Thread.currentThread().interrupt();
            thread.shutdown();
            Assertions.fail((String)"Shutdown should have been interrupted");
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            Exit.resetExitProcedure();
        }
        afterTest.countDown();
    }
}

