/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;

public final class ControllerMetadataMetrics
implements AutoCloseable {
    private static final MetricName METADATA_ERROR_COUNT = ControllerMetadataMetrics.getMetricName("KafkaController", "MetadataErrorCount");
    private final Optional<MetricsRegistry> registry;
    private final AtomicInteger metadataErrorCount = new AtomicInteger(0);

    public ControllerMetadataMetrics(Optional<MetricsRegistry> registry) {
        this.registry = registry;
        registry.ifPresent(r -> r.newGauge(METADATA_ERROR_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return ControllerMetadataMetrics.this.metadataErrorCount();
            }
        }));
    }

    public void incrementMetadataErrorCount() {
        this.metadataErrorCount.getAndIncrement();
    }

    public int metadataErrorCount() {
        return this.metadataErrorCount.get();
    }

    @Override
    public void close() {
        this.registry.ifPresent(r -> Arrays.asList(METADATA_ERROR_COUNT).forEach(arg_0 -> ((MetricsRegistry)r).removeMetric(arg_0)));
    }

    private static MetricName getMetricName(String type, String name) {
        return KafkaYammerMetrics.getMetricName((String)"kafka.controller", (String)type, (String)name);
    }
}

