/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.publisher;

import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.server.common.FinalizedFeatures;
import org.apache.kafka.server.common.MetadataVersion;
import org.slf4j.Logger;

public class FeaturesPublisher
implements MetadataPublisher {
    private final Logger log;
    private volatile FinalizedFeatures finalizedFeatures = FinalizedFeatures.fromKRaftVersion((MetadataVersion)MetadataVersion.MINIMUM_VERSION);

    public FeaturesPublisher(LogContext logContext) {
        this.log = logContext.logger(FeaturesPublisher.class);
    }

    public FinalizedFeatures features() {
        return this.finalizedFeatures;
    }

    @Override
    public String name() {
        return "FeaturesPublisher";
    }

    @Override
    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        FinalizedFeatures newFinalizedFeatures;
        if (delta.featuresDelta() != null && !(newFinalizedFeatures = new FinalizedFeatures(newImage.features().metadataVersionOrThrow(), newImage.features().finalizedVersions(), newImage.provenance().lastContainedOffset())).equals((Object)this.finalizedFeatures)) {
            this.log.info("Loaded new metadata {}.", (Object)newFinalizedFeatures);
            this.finalizedFeatures = newFinalizedFeatures;
        }
    }
}

