/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.bootstrap;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.metadata.util.BatchFileReader;
import org.apache.kafka.metadata.util.BatchFileWriter;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;

public class BootstrapDirectory {
    public static final String BINARY_BOOTSTRAP_FILENAME = "bootstrap.checkpoint";
    private final String directoryPath;
    private final Optional<String> ibp;

    public BootstrapDirectory(String directoryPath, Optional<String> ibp) {
        this.directoryPath = Objects.requireNonNull(directoryPath);
        this.ibp = Objects.requireNonNull(ibp);
    }

    public BootstrapMetadata read() throws Exception {
        if (!Files.isDirectory(Paths.get(this.directoryPath, new String[0]), new LinkOption[0])) {
            if (Files.exists(Paths.get(this.directoryPath, new String[0]), new LinkOption[0])) {
                throw new RuntimeException("Path " + this.directoryPath + " exists, but is not a directory.");
            }
            throw new RuntimeException("No such directory as " + this.directoryPath);
        }
        Path binaryBootstrapPath = Paths.get(this.directoryPath, BINARY_BOOTSTRAP_FILENAME);
        if (!Files.exists(binaryBootstrapPath, new LinkOption[0])) {
            return this.readFromConfiguration();
        }
        return this.readFromBinaryFile(binaryBootstrapPath.toString());
    }

    BootstrapMetadata readFromConfiguration() {
        if (!this.ibp.isPresent()) {
            return BootstrapMetadata.fromVersion(MetadataVersion.latest(), "the default bootstrap");
        }
        MetadataVersion version = MetadataVersion.fromVersionString((String)this.ibp.get());
        if (version.isLessThan(MetadataVersion.MINIMUM_BOOTSTRAP_VERSION)) {
            return BootstrapMetadata.fromVersion(MetadataVersion.MINIMUM_BOOTSTRAP_VERSION, "the minimum version bootstrap with metadata.version " + MetadataVersion.MINIMUM_BOOTSTRAP_VERSION);
        }
        return BootstrapMetadata.fromVersion(version, "the configured bootstrap with metadata.version " + version);
    }

    BootstrapMetadata readFromBinaryFile(String binaryPath) throws Exception {
        ArrayList records = new ArrayList();
        try (BatchFileReader reader = new BatchFileReader.Builder().setPath(binaryPath).build();){
            while (reader.hasNext()) {
                BatchFileReader.BatchAndType batchAndType = reader.next();
                if (batchAndType.isControl()) continue;
                records.addAll(batchAndType.batch().records());
            }
        }
        return BootstrapMetadata.fromRecords(Collections.unmodifiableList(records), "the binary bootstrap metadata file: " + binaryPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBinaryFile(BootstrapMetadata bootstrapMetadata) throws Exception {
        if (!Files.isDirectory(Paths.get(this.directoryPath, new String[0]), new LinkOption[0])) {
            throw new RuntimeException("No such directory as " + this.directoryPath);
        }
        Path tempPath = Paths.get(this.directoryPath, "bootstrap.checkpoint.tmp");
        Files.deleteIfExists(tempPath);
        try {
            try (BatchFileWriter writer = BatchFileWriter.open(tempPath);){
                for (ApiMessageAndVersion message : bootstrapMetadata.records()) {
                    writer.append(message);
                }
            }
            Files.move(tempPath, Paths.get(this.directoryPath, BINARY_BOOTSTRAP_FILENAME), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            Files.deleteIfExists(tempPath);
        }
    }
}

