/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node.printer;

import java.util.ArrayDeque;
import org.apache.kafka.image.node.printer.MetadataNodePrinter;
import org.apache.kafka.image.node.printer.MetadataNodeRedactionCriteria;

public class NodeStringifier
implements MetadataNodePrinter {
    private final MetadataNodeRedactionCriteria redactionCriteria;
    private final StringBuilder stringBuilder;
    private final ArrayDeque<String> prefixes;

    public NodeStringifier() {
        this(MetadataNodeRedactionCriteria.Strict.INSTANCE);
    }

    public NodeStringifier(MetadataNodeRedactionCriteria redactionCriteria) {
        this.redactionCriteria = redactionCriteria;
        this.stringBuilder = new StringBuilder();
        this.prefixes = new ArrayDeque();
        this.prefixes.push("");
    }

    @Override
    public MetadataNodeRedactionCriteria redactionCriteria() {
        return this.redactionCriteria;
    }

    @Override
    public void enterNode(String name) {
        this.stringBuilder.append(this.prefixes.pop());
        this.prefixes.push(", ");
        this.stringBuilder.append(name).append("(");
        this.prefixes.push("");
    }

    @Override
    public void leaveNode() {
        this.stringBuilder.append(")");
        this.prefixes.pop();
    }

    @Override
    public void output(String text) {
        this.stringBuilder.append(this.prefixes.pop()).append(text);
        this.prefixes.push(", ");
    }

    public String toString() {
        return this.stringBuilder.toString();
    }
}

