/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.metadata.PartitionRegistration;

public final class TopicImage {
    private final String name;
    private final Uuid id;
    private final Map<Integer, PartitionRegistration> partitions;

    public TopicImage(String name, Uuid id, Map<Integer, PartitionRegistration> partitions) {
        this.name = name;
        this.id = id;
        this.partitions = partitions;
    }

    public String name() {
        return this.name;
    }

    public Uuid id() {
        return this.id;
    }

    public Map<Integer, PartitionRegistration> partitions() {
        return this.partitions;
    }

    public void write(ImageWriter writer, ImageWriterOptions options) {
        writer.write(0, new TopicRecord().setName(this.name).setTopicId(this.id));
        for (Map.Entry<Integer, PartitionRegistration> entry : this.partitions.entrySet()) {
            int partitionId = entry.getKey();
            PartitionRegistration partition = entry.getValue();
            writer.write(partition.toRecord(this.id, partitionId));
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof TopicImage)) {
            return false;
        }
        TopicImage other = (TopicImage)o;
        return this.name.equals(other.name) && this.id.equals((Object)other.id) && this.partitions.equals(other.partitions);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.id, this.partitions);
    }

    public String toString() {
        return "TopicImage(name=" + this.name + ", id=" + this.id + ", partitions=" + this.partitions.entrySet().stream().map(e -> e.getKey() + ":" + e.getValue()).collect(Collectors.joining(", ")) + ")";
    }
}

