/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.ApplicationProtocolNegotiator;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.Log4J2LoggerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.common.security.ssl.CloseableSslEngineFactory;
import org.apache.kafka.common.security.ssl.DefaultSslEngineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettySslEngineFactory
extends DefaultSslEngineFactory
implements CloseableSslEngineFactory {
    private static final Logger log = LoggerFactory.getLogger(NettySslEngineFactory.class);
    private AtomicReference<SslContext> nettySslClientContext = new AtomicReference<Object>(null);
    private AtomicReference<SslContext> nettySslServerContext = new AtomicReference<Object>(null);
    private ApplicationProtocolConfig appProtocolConfig = ApplicationProtocolConfig.DISABLED;
    private volatile State state = State.INITIAL;

    @Override
    public SSLEngine createClientSslEngine(String peerHost, int peerPort, String endpointIdentification) {
        return this.createClientSslEngine(ByteBufAllocator.DEFAULT, peerHost, peerPort, endpointIdentification);
    }

    @Override
    public SSLEngine createServerSslEngine(String peerHost, int peerPort) {
        return this.createServerSslEngine(ByteBufAllocator.DEFAULT, peerHost, peerPort);
    }

    public static boolean configsContainKeystore(Map<String, ?> configs) {
        return configs.containsKey("ssl.keystore.type") && configs.containsKey("ssl.keystore.location") && configs.containsKey("ssl.keystore.password");
    }

    @Override
    public void configure(Map<String, ?> configs) {
        this.appProtocolConfig = ConfluentConfigs.getApplicationProtocolConfig(configs);
        super.configure(configs);
        this.state = State.CONFIGURED;
    }

    SslContext clientSslContext() {
        return this.nettySslClientContext.get();
    }

    SslContext serverSslContext() {
        return this.nettySslServerContext.get();
    }

    @Override
    public synchronized void close() {
        super.close();
        NettySslEngineFactory.releaseSslContext(this.nettySslClientContext.getAndSet(null));
        NettySslEngineFactory.releaseSslContext(this.nettySslServerContext.getAndSet(null));
        this.state = State.CLOSED;
    }

    private static void releaseSslContext(SslContext sslContext) {
        if (sslContext != null) {
            ReferenceCountUtil.release((Object)sslContext);
        }
    }

    @Override
    protected synchronized void createAndSetSSLContext() {
        super.createAndSetSSLContext();
        if (!OpenSsl.isAvailable()) {
            this.nettySslClientContext = null;
            this.nettySslServerContext = null;
        } else if (this.state != State.CLOSED) {
            NettySslEngineFactory.releaseSslContext(this.nettySslClientContext.getAndSet(this.createNettySslContext(ConnectionMode.CLIENT)));
            if (NettySslEngineFactory.configsContainKeystore(this.configs())) {
                NettySslEngineFactory.releaseSslContext(this.nettySslServerContext.getAndSet(this.createNettySslContext(ConnectionMode.SERVER)));
            }
        }
    }

    public SSLSessionContext clientSessionContext() {
        if (this.nettySslClientContext.get() == null) {
            throw new RuntimeException("Cannot get SSLSessionContext since this factory could not be configured for client");
        }
        return this.nettySslClientContext.get().sessionContext();
    }

    public SSLSessionContext serverSessionContext() {
        if (this.nettySslServerContext.get() == null) {
            throw new RuntimeException("Cannot get SSLSessionContext since this factory could not be configured for server");
        }
        return this.nettySslServerContext.get().sessionContext();
    }

    public ApplicationProtocolNegotiator clientApplicationProtocolNegotiator() {
        if (this.nettySslClientContext.get() == null) {
            throw new RuntimeException("Cannot get ApplicationProtocolNegotiator since this factory could not be configured for client");
        }
        return this.nettySslClientContext.get().applicationProtocolNegotiator();
    }

    public ApplicationProtocolNegotiator serverApplicationProtocolNegotiator() {
        if (this.nettySslServerContext.get() == null) {
            throw new RuntimeException("Cannot get ApplicationProtocolNegotiator since this factory could not be configured for server");
        }
        return this.nettySslServerContext.get().applicationProtocolNegotiator();
    }

    public SSLEngine createServerSslEngine(ByteBufAllocator byteBufAllocator, String peerHost, int peerPort) {
        if (this.state != State.CONFIGURED) {
            throw new RuntimeException("Cannot create SSLEngine since this factory has not yet been configured");
        }
        if (this.nettySslServerContext == null || this.nettySslServerContext.get() == null) {
            throw new RuntimeException("Cannot create SSLEngine since this factory could not be configured for server");
        }
        return this.nettySslServerContext.get().newEngine(byteBufAllocator, peerHost, peerPort);
    }

    public SSLEngine createClientSslEngine(ByteBufAllocator byteBufAllocator, String peerHost, int peerPort, String endpointIdentificationAlgorithm) {
        if (this.state != State.CONFIGURED) {
            throw new RuntimeException("Cannot create SSLEngine since this factory has not yet been configured");
        }
        if (this.nettySslClientContext == null || this.nettySslClientContext.get() == null) {
            throw new RuntimeException("Cannot create SSLEngine since this factory could not be configured for client");
        }
        SSLEngine sslEngine = this.nettySslClientContext.get().newEngine(byteBufAllocator, peerHost, peerPort);
        SSLParameters sslParams = sslEngine.getSSLParameters();
        sslParams.setEndpointIdentificationAlgorithm(endpointIdentificationAlgorithm);
        sslEngine.setSSLParameters(sslParams);
        return sslEngine;
    }

    static boolean isNettyJarsConfiguredCorrectly() {
        boolean containsNonFipsJar;
        String[] paths = System.getProperty("java.class.path").split(System.getProperty("path.separator"));
        boolean containsFipsJar = Arrays.asList(paths).stream().filter(path -> path.endsWith(".jar")).anyMatch(path -> path.contains("netty-tcnative-fips-boringssl-static-"));
        return containsFipsJar != (containsNonFipsJar = Arrays.asList(paths).stream().filter(path -> path.endsWith(".jar")).anyMatch(path -> path.contains("netty-tcnative-boringssl-static-")));
    }

    public static boolean isConfigurable(Map<String, ?> configs, ConnectionMode connectionMode) {
        if (!NettySslEngineFactory.isNettyJarsConfiguredCorrectly()) {
            log.error("Both fips and non-fips netty-tcnative jars cannot be present in the class path");
            throw new RuntimeException("Both fips and non-fips netty-tcnative jars cannot be present in the class path");
        }
        if (connectionMode == ConnectionMode.SERVER && !NettySslEngineFactory.configsContainKeystore(configs)) {
            log.warn("Cannot configure Netty server because keystore is not configured.");
            return false;
        }
        if (!OpenSsl.isAvailable()) {
            log.warn("Cannot configure Netty because no OpenSSL is available.", OpenSsl.unavailabilityCause());
            return false;
        }
        return true;
    }

    @Override
    public Closeable sslEngineCloser(SSLEngine engine) {
        return new CloseableSslEngine(engine);
    }

    DefaultSslEngineFactory.PrivateKeyData loadPrivateKeyData() {
        DefaultSslEngineFactory.SecurityStore keyStore = this.securityKeyStore();
        KeyStore store = keyStore.get();
        try {
            Enumeration<String> aliases = store.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!store.isKeyEntry(alias)) continue;
                try {
                    Key key = store.getKey(alias, keyStore.keyPassword());
                    if (!(key instanceof PrivateKey)) continue;
                    Certificate[] certs = store.getCertificateChain(alias);
                    ArrayList<X509Certificate> x509Cert = new ArrayList<X509Certificate>();
                    if (certs != null) {
                        for (Certificate cert : certs) {
                            if (!(cert instanceof X509Certificate)) {
                                throw new RuntimeException("Expected a certificate chain of type X509Certificate for alias " + alias);
                            }
                            x509Cert.add((X509Certificate)cert);
                        }
                    }
                    return new DefaultSslEngineFactory.PrivateKeyData((PrivateKey)key, x509Cert.toArray(new X509Certificate[0]));
                }
                catch (NoSuchAlgorithmException e) {
                    log.info("can't find the algorithm for recovering the {} entry.", (Object)alias);
                }
                catch (UnrecoverableEntryException e) {
                    log.trace("ignoring alias {}, since the password doesn't match.", (Object)alias);
                }
            }
        }
        catch (KeyStoreException e) {
            throw new KafkaException(e);
        }
        throw new RuntimeException("No private key found protected with the given password in " + keyStore.toString());
    }

    private SslContext createNettySslContext(ConnectionMode connectionMode) {
        try {
            SslContextBuilder builder;
            DefaultSslEngineFactory.PrivateKeyData keystorePrivateKeyData = null;
            if (connectionMode == ConnectionMode.SERVER && this.keystore() == null) {
                throw new KafkaException("When using Netty in server mode, a keystore must be configured.");
            }
            if (this.keystore() != null) {
                keystorePrivateKeyData = this.loadPrivateKeyData();
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(this.tmfAlgorithm());
            tmf.init(this.truststore());
            if (connectionMode == ConnectionMode.SERVER) {
                builder = SslContextBuilder.forServer((PrivateKey)keystorePrivateKeyData.key(), (X509Certificate[])keystorePrivateKeyData.certificateChain());
            } else {
                builder = SslContextBuilder.forClient();
                if (keystorePrivateKeyData != null) {
                    builder.keyManager(keystorePrivateKeyData.key(), keystorePrivateKeyData.certificateChain());
                }
            }
            builder.applicationProtocolConfig(this.appProtocolConfig).sslProvider(SslProvider.OPENSSL_REFCNT).trustManager(tmf);
            if (this.enabledProtocols() != null) {
                builder.protocols(this.enabledProtocols());
            }
            if (this.cipherSuites() != null) {
                builder.ciphers(Arrays.asList(this.cipherSuites()));
            }
            if (connectionMode == ConnectionMode.SERVER) {
                switch (this.sslClientAuth()) {
                    case NONE: {
                        builder.clientAuth(ClientAuth.NONE);
                        break;
                    }
                    case REQUIRED: {
                        builder.clientAuth(ClientAuth.REQUIRE);
                        break;
                    }
                    case REQUESTED: {
                        builder.clientAuth(ClientAuth.OPTIONAL);
                    }
                }
            }
            log.info("Netty is enabled in {} mode for SSL context with keystore {}, truststore {}.", new Object[]{connectionMode, this.keystore(), this.truststore()});
            return builder.build();
        }
        catch (Exception e) {
            throw new InvalidConfigurationException("Netty SSL context could not be created with the provided configs", e);
        }
    }

    static {
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)Log4J2LoggerFactory.INSTANCE);
        System.setProperty("io.netty.handler.ssl.openssl.useTasks", "false");
    }

    private static enum State {
        INITIAL,
        CONFIGURED,
        CLOSED;

    }

    static class CloseableSslEngine
    implements Closeable {
        private final SSLEngine engine;

        CloseableSslEngine(SSLEngine engine) {
            this.engine = engine;
        }

        @Override
        public void close() throws IOException {
            ReferenceCountUtil.release((Object)this.engine);
        }
    }
}

