/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer;

import io.confluent.kafka.security.oauthbearer.HttpRequestFormatterFactory;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.security.oauthbearer.FileJwtRetriever;
import org.apache.kafka.common.security.oauthbearer.JwtRetriever;
import org.apache.kafka.common.security.oauthbearer.JwtRetrieverException;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ConfigurationUtils;
import org.apache.kafka.common.security.oauthbearer.internals.secured.HttpJwtRetriever;
import org.apache.kafka.common.security.oauthbearer.internals.secured.HttpRequestFormatter;
import org.apache.kafka.common.security.oauthbearer.internals.secured.JaasOptionsUtils;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJwtRetriever
implements JwtRetriever {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJwtRetriever.class);
    private JwtRetriever delegate;

    @Override
    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        ConfigurationUtils cu = new ConfigurationUtils(configs, saslMechanism);
        URL tokenEndpointUrl = cu.validateUrl("sasl.oauthbearer.token.endpoint.url");
        if (tokenEndpointUrl.getProtocol().toLowerCase(Locale.ROOT).equals("file")) {
            this.delegate = new FileJwtRetriever();
        } else {
            JaasOptionsUtils jou = new JaasOptionsUtils(saslMechanism, jaasConfigEntries);
            HttpRequestFormatter httpRequestFormatter = HttpRequestFormatterFactory.create(cu, jou);
            this.delegate = new HttpJwtRetriever(httpRequestFormatter);
        }
        LOG.debug("Created instance of {} as delegate", (Object)this.delegate.getClass().getName());
        this.delegate.configure(configs, saslMechanism, jaasConfigEntries);
    }

    @Override
    public String retrieve() throws JwtRetrieverException {
        if (this.delegate == null) {
            throw new IllegalStateException("JWT retriever delegate is null; please call configure() first");
        }
        return this.delegate.retrieve();
    }

    @Override
    public void close() throws IOException {
        Utils.closeQuietly(this.delegate, "JWT retriever delegate");
    }

    JwtRetriever delegate() {
        return this.delegate;
    }
}

