/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.message.InitiateReverseConnectionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class InitiateReverseConnectionsResponse
extends AbstractResponse {
    public final InitiateReverseConnectionsResponseData data;

    public InitiateReverseConnectionsResponse(InitiateReverseConnectionsResponseData data) {
        super(ApiKeys.INITIATE_REVERSE_CONNECTIONS);
        this.data = data;
    }

    public InitiateReverseConnectionsResponse(Collection<Integer> requestIds, int throttleTimeMs, Throwable e) {
        super(ApiKeys.INITIATE_REVERSE_CONNECTIONS);
        short errorCode = Errors.forException(e).code();
        String errorMessage = e.getMessage();
        ArrayList<InitiateReverseConnectionsResponseData.EntryData> entryDatas = new ArrayList<InitiateReverseConnectionsResponseData.EntryData>(requestIds.size());
        for (int requestId : requestIds) {
            entryDatas.add(new InitiateReverseConnectionsResponseData.EntryData().setErrorCode(errorCode).setErrorMessage(errorMessage).setInitiateRequestId(requestId));
        }
        this.data = new InitiateReverseConnectionsResponseData().setThrottleTimeMs(throttleTimeMs).setEntries(entryDatas);
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> counts = new HashMap<Errors, Integer>();
        for (InitiateReverseConnectionsResponseData.EntryData entry : this.data.entries()) {
            Errors error = Errors.forCode(entry.errorCode());
            counts.put(error, counts.getOrDefault((Object)error, 0) + 1);
        }
        return counts;
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    @Override
    public InitiateReverseConnectionsResponseData data() {
        return this.data;
    }

    public static InitiateReverseConnectionsResponse parse(Readable readable, short version, MessageContext context) {
        return new InitiateReverseConnectionsResponse(new InitiateReverseConnectionsResponseData(readable, version, context));
    }

    public boolean equals(Object other) {
        return other instanceof InitiateReverseConnectionsResponse && ((InitiateReverseConnectionsResponse)other).data.equals(this.data);
    }

    public int hashCode() {
        return Objects.hashCode(this.data);
    }
}

