/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.InitializeShareGroupStateRequestData;
import org.apache.kafka.common.message.InitializeShareGroupStateResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class InitializeShareGroupStateResponse
extends AbstractResponse {
    private final InitializeShareGroupStateResponseData data;

    public InitializeShareGroupStateResponse(InitializeShareGroupStateResponseData data) {
        super(ApiKeys.INITIALIZE_SHARE_GROUP_STATE);
        this.data = data;
    }

    @Override
    public InitializeShareGroupStateResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        EnumMap<Errors, Integer> counts = new EnumMap<Errors, Integer>(Errors.class);
        this.data.results().forEach(result -> result.partitions().forEach(partitionResult -> InitializeShareGroupStateResponse.updateErrorCounts(counts, Errors.forCode(partitionResult.errorCode()))));
        return counts;
    }

    @Override
    public int throttleTimeMs() {
        return 0;
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
    }

    public static InitializeShareGroupStateResponse parse(Readable readable, short version, MessageContext context) {
        return new InitializeShareGroupStateResponse(new InitializeShareGroupStateResponseData(readable, version, context));
    }

    public static InitializeShareGroupStateResponseData toGlobalErrorResponse(InitializeShareGroupStateRequestData request, Errors error) {
        ArrayList<InitializeShareGroupStateResponseData.InitializeStateResult> initStateResults = new ArrayList<InitializeShareGroupStateResponseData.InitializeStateResult>();
        request.topics().forEach(topicData -> {
            ArrayList<InitializeShareGroupStateResponseData.PartitionResult> partitionResults = new ArrayList<InitializeShareGroupStateResponseData.PartitionResult>();
            topicData.partitions().forEach(partitionData -> partitionResults.add(InitializeShareGroupStateResponse.toErrorResponsePartitionResult(partitionData.partition(), error, error.message())));
            initStateResults.add(InitializeShareGroupStateResponse.toResponseInitializeStateResult(topicData.topicId(), partitionResults));
        });
        return new InitializeShareGroupStateResponseData().setResults(initStateResults);
    }

    public static InitializeShareGroupStateResponseData.PartitionResult toErrorResponsePartitionResult(int partitionId, Errors error, String errorMessage) {
        return new InitializeShareGroupStateResponseData.PartitionResult().setPartition(partitionId).setErrorCode(error.code()).setErrorMessage(errorMessage);
    }

    public static InitializeShareGroupStateResponseData.InitializeStateResult toResponseInitializeStateResult(Uuid topicId, List<InitializeShareGroupStateResponseData.PartitionResult> partitionResults) {
        return new InitializeShareGroupStateResponseData.InitializeStateResult().setTopicId(topicId).setPartitions(partitionResults);
    }

    public static InitializeShareGroupStateResponseData toErrorResponseData(Uuid topicId, int partitionId, Errors error, String errorMessage) {
        return new InitializeShareGroupStateResponseData().setResults(List.of(new InitializeShareGroupStateResponseData.InitializeStateResult().setTopicId(topicId).setPartitions(List.of(new InitializeShareGroupStateResponseData.PartitionResult().setPartition(partitionId).setErrorCode(error.code()).setErrorMessage(errorMessage)))));
    }

    public static InitializeShareGroupStateResponseData.PartitionResult toResponsePartitionResult(int partitionId) {
        return new InitializeShareGroupStateResponseData.PartitionResult().setPartition(partitionId);
    }

    public static InitializeShareGroupStateResponseData toResponseData(Uuid topicId, int partitionId) {
        return new InitializeShareGroupStateResponseData().setResults(List.of(new InitializeShareGroupStateResponseData.InitializeStateResult().setTopicId(topicId).setPartitions(List.of(new InitializeShareGroupStateResponseData.PartitionResult().setPartition(partitionId)))));
    }
}

