/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.clients.admin.ClusterLinkSwitchoverStatusDescription;
import org.apache.kafka.clients.admin.ClusterLinkTaskDescription;
import org.apache.kafka.clients.admin.ClusterLinkTaskError;
import org.apache.kafka.clients.admin.ClusterLinkTopicSwitchoverInfo;
import org.apache.kafka.clients.admin.MirrorTopicDescription;
import org.apache.kafka.common.ClusterLinkError;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.DescribeSwitchoverStatusResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class DescribeSwitchoverStatusResponse
extends AbstractResponse {
    public final DescribeSwitchoverStatusResponseData data;

    public DescribeSwitchoverStatusResponse(DescribeSwitchoverStatusResponseData data) {
        super(ApiKeys.DESCRIBE_SWITCHOVER_STATUS);
        this.data = data;
    }

    public DescribeSwitchoverStatusResponse(int throttleTimeMs, Throwable e) {
        super(ApiKeys.DESCRIBE_SWITCHOVER_STATUS);
        this.data = new DescribeSwitchoverStatusResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(Errors.forException(e).code()).setErrorMessage(e.getMessage());
    }

    public static DescribeSwitchoverStatusResponse parse(Readable readable, short version, MessageContext context) {
        return new DescribeSwitchoverStatusResponse(new DescribeSwitchoverStatusResponseData(readable, version, context));
    }

    public void complete(KafkaFutureImpl<ClusterLinkSwitchoverStatusDescription> result) {
        Errors error = Errors.forCode(this.data.errorCode());
        if (error != Errors.NONE) {
            result.completeExceptionally(error.exception(this.data.errorMessage()));
            return;
        }
        ClusterLinkSwitchoverStatusDescription switchoverStatusDescription = DescribeSwitchoverStatusResponse.responseDataToSwitchoverStatusDescription(this.data);
        result.complete(switchoverStatusDescription);
    }

    public static ClusterLinkSwitchoverStatusDescription responseDataToSwitchoverStatusDescription(DescribeSwitchoverStatusResponseData data) {
        HashMap<String, Optional<ClusterLinkTopicSwitchoverInfo>> topicToTopicSwitchover = new HashMap<String, Optional<ClusterLinkTopicSwitchoverInfo>>();
        for (DescribeSwitchoverStatusResponseData.TopicData topicData : data.topics()) {
            if (topicData.state() == null) {
                topicToTopicSwitchover.put(topicData.topic(), Optional.empty());
            }
            ClusterLinkTopicSwitchoverInfo topicSwitchoverInfo = new ClusterLinkTopicSwitchoverInfo(topicData.topic(), topicData.errorCode(), topicData.errorMessage(), topicData.switchoverMessagesTruncated(), DescribeSwitchoverStatusResponse.toState(topicData.state()));
            topicToTopicSwitchover.put(topicData.topic(), Optional.of(topicSwitchoverInfo));
        }
        return new ClusterLinkSwitchoverStatusDescription(data.linkName(), data.linkId(), data.remoteClusterId(), data.localClusterId(), topicToTopicSwitchover, ClusterLinkDescription.LinkState.fromShort(data.linkState()), ClusterLinkDescription.LinkState.fromShort(data.remoteLinkState()), ClusterLinkError.fromShort(data.linkErrorCode()), data.errorMessage(), ClusterLinkError.fromShort(data.remoteLinkErrorCode()), data.remoteLinkErrorMessage(), DescribeSwitchoverStatusResponse.toAdminClientLinkTaskDescriptions(data.tasks()), ClusterLinkSwitchoverStatusDescription.SwitchoverType.fromValue(data.switchoverType()), ClusterLinkSwitchoverStatusDescription.SwitchoverState.fromValue(data.switchoverState()));
    }

    private static List<ClusterLinkTaskDescription> toAdminClientLinkTaskDescriptions(List<DescribeSwitchoverStatusResponseData.TaskData> taskDataList) {
        List<ClusterLinkTaskDescription> result = taskDataList == null ? Collections.emptyList() : taskDataList.stream().map(taskData -> {
            String name = taskData.name();
            ClusterLinkTaskDescription.ClusterLinkTaskState state = ClusterLinkTaskDescription.ClusterLinkTaskState.fromShort(taskData.state());
            List<ClusterLinkTaskError> errs = taskData.errors() == null ? Collections.emptyList() : taskData.errors().stream().map(err -> new ClusterLinkTaskError(ClusterLinkTaskError.ClusterLinkTaskErrorCode.fromShort(err.errorCode()), err.errorMessage())).collect(Collectors.toList());
            return new ClusterLinkTaskDescription(name, state, errs);
        }).collect(Collectors.toList());
        return result;
    }

    private static MirrorTopicDescription.State toState(String state) {
        try {
            return MirrorTopicDescription.State.valueOf(state);
        }
        catch (IllegalArgumentException e) {
            return MirrorTopicDescription.State.UNKNOWN;
        }
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return Collections.singletonMap(Errors.forCode(this.data.errorCode()), 1);
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public DescribeSwitchoverStatusResponseData data() {
        return this.data;
    }
}

