/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.DescribeDelegationTokenRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.DescribeDelegationTokenResponse;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class DescribeDelegationTokenRequest
extends AbstractRequest {
    private final DescribeDelegationTokenRequestData data;

    public DescribeDelegationTokenRequest(DescribeDelegationTokenRequestData data, short version) {
        super(ApiKeys.DESCRIBE_DELEGATION_TOKEN, version);
        this.data = data;
    }

    @Override
    public DescribeDelegationTokenRequestData data() {
        return this.data;
    }

    public boolean ownersListEmpty() {
        return this.data.owners() != null && this.data.owners().isEmpty();
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new DescribeDelegationTokenResponse(this.version(), throttleTimeMs, Errors.forException(e));
    }

    public static DescribeDelegationTokenRequest parse(Readable readable, short version, MessageContext context) {
        return new DescribeDelegationTokenRequest(new DescribeDelegationTokenRequestData(readable, version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<DescribeDelegationTokenRequest> {
        private final DescribeDelegationTokenRequestData data;

        public Builder(List<KafkaPrincipal> owners) {
            super(ApiKeys.DESCRIBE_DELEGATION_TOKEN);
            this.data = new DescribeDelegationTokenRequestData().setOwners(owners == null ? null : owners.stream().map(owner -> new DescribeDelegationTokenRequestData.DescribeDelegationTokenOwner().setPrincipalName(owner.getName()).setPrincipalType(owner.getPrincipalType())).collect(Collectors.toList()));
        }

        @Override
        public DescribeDelegationTokenRequest build(short version) {
            return new DescribeDelegationTokenRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

