/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.SendBuilder;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.requests.AddOffsetsToTxnResponse;
import org.apache.kafka.common.requests.AddPartitionsToTxnResponse;
import org.apache.kafka.common.requests.AddRaftVoterResponse;
import org.apache.kafka.common.requests.AllocateProducerIdsResponse;
import org.apache.kafka.common.requests.AlterBrokerHealthResponse;
import org.apache.kafka.common.requests.AlterBrokerReplicaExclusionsResponse;
import org.apache.kafka.common.requests.AlterCellMigrationResponse;
import org.apache.kafka.common.requests.AlterCellResponse;
import org.apache.kafka.common.requests.AlterClientQuotasResponse;
import org.apache.kafka.common.requests.AlterClusterLinksResponse;
import org.apache.kafka.common.requests.AlterConfigsResponse;
import org.apache.kafka.common.requests.AlterMirrorTopicsResponse;
import org.apache.kafka.common.requests.AlterMirrorsResponse;
import org.apache.kafka.common.requests.AlterPartitionReassignmentsResponse;
import org.apache.kafka.common.requests.AlterPartitionResponse;
import org.apache.kafka.common.requests.AlterReplicaLogDirsResponse;
import org.apache.kafka.common.requests.AlterShareGroupOffsetsResponse;
import org.apache.kafka.common.requests.AlterUserScramCredentialsResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.AppendRecordsResponse;
import org.apache.kafka.common.requests.AssignBrokersToCellResponse;
import org.apache.kafka.common.requests.AssignReplicasToDirsResponse;
import org.apache.kafka.common.requests.AssignTenantsToCellResponse;
import org.apache.kafka.common.requests.BeginQuorumEpochResponse;
import org.apache.kafka.common.requests.BrokerHeartbeatResponse;
import org.apache.kafka.common.requests.BrokerRegistrationResponse;
import org.apache.kafka.common.requests.ComputeEvenClusterLoadPlanResponse;
import org.apache.kafka.common.requests.ConsumerGroupDescribeResponse;
import org.apache.kafka.common.requests.ConsumerGroupHeartbeatResponse;
import org.apache.kafka.common.requests.ControllerRegistrationResponse;
import org.apache.kafka.common.requests.CorrelationIdMismatchException;
import org.apache.kafka.common.requests.CreateAclsResponse;
import org.apache.kafka.common.requests.CreateCellResponse;
import org.apache.kafka.common.requests.CreateClusterLinksResponse;
import org.apache.kafka.common.requests.CreateDelegationTokenResponse;
import org.apache.kafka.common.requests.CreatePartitionsResponse;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.DeleteAclsResponse;
import org.apache.kafka.common.requests.DeleteCellResponse;
import org.apache.kafka.common.requests.DeleteClusterLinksResponse;
import org.apache.kafka.common.requests.DeleteGroupsResponse;
import org.apache.kafka.common.requests.DeleteRecordsResponse;
import org.apache.kafka.common.requests.DeleteShareGroupOffsetsResponse;
import org.apache.kafka.common.requests.DeleteShareGroupStateResponse;
import org.apache.kafka.common.requests.DeleteTenantsResponse;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.DescribeAclsResponse;
import org.apache.kafka.common.requests.DescribeBalancerStatusResponse;
import org.apache.kafka.common.requests.DescribeBrokerAdditionsResponse;
import org.apache.kafka.common.requests.DescribeBrokerHealthResponse;
import org.apache.kafka.common.requests.DescribeBrokerRemovalsResponse;
import org.apache.kafka.common.requests.DescribeBrokerReplicaExclusionsResponse;
import org.apache.kafka.common.requests.DescribeCellLoadResponse;
import org.apache.kafka.common.requests.DescribeCellMigrationResponse;
import org.apache.kafka.common.requests.DescribeCellsResponse;
import org.apache.kafka.common.requests.DescribeClientQuotasResponse;
import org.apache.kafka.common.requests.DescribeClusterLinksResponse;
import org.apache.kafka.common.requests.DescribeClusterResponse;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.common.requests.DescribeDelegationTokenResponse;
import org.apache.kafka.common.requests.DescribeEvenClusterLoadStatusResponse;
import org.apache.kafka.common.requests.DescribeGroupsResponse;
import org.apache.kafka.common.requests.DescribeLogDirsResponse;
import org.apache.kafka.common.requests.DescribeMirrorsResponse;
import org.apache.kafka.common.requests.DescribeNetworkResponse;
import org.apache.kafka.common.requests.DescribeProducersResponse;
import org.apache.kafka.common.requests.DescribeQuorumResponse;
import org.apache.kafka.common.requests.DescribeShareGroupOffsetsResponse;
import org.apache.kafka.common.requests.DescribeSwitchoverStatusResponse;
import org.apache.kafka.common.requests.DescribeTenantsResponse;
import org.apache.kafka.common.requests.DescribeTopicPartitionsResponse;
import org.apache.kafka.common.requests.DescribeTransactionsResponse;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsResponse;
import org.apache.kafka.common.requests.DrainCellResponse;
import org.apache.kafka.common.requests.ElectLeadersResponse;
import org.apache.kafka.common.requests.EndQuorumEpochResponse;
import org.apache.kafka.common.requests.EndTxnResponse;
import org.apache.kafka.common.requests.EnvelopeResponse;
import org.apache.kafka.common.requests.ExpireDelegationTokenResponse;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.FetchSnapshotResponse;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.requests.GetTelemetrySubscriptionsResponse;
import org.apache.kafka.common.requests.HeartbeatResponse;
import org.apache.kafka.common.requests.IncrementalAlterConfigsResponse;
import org.apache.kafka.common.requests.InitProducerIdResponse;
import org.apache.kafka.common.requests.InitializeShareGroupStateResponse;
import org.apache.kafka.common.requests.InitiateReverseConnectionsResponse;
import org.apache.kafka.common.requests.InitiateShutdownResponse;
import org.apache.kafka.common.requests.JoinGroupResponse;
import org.apache.kafka.common.requests.LeaveGroupResponse;
import org.apache.kafka.common.requests.ListClusterLinksResponse;
import org.apache.kafka.common.requests.ListConfigResourcesResponse;
import org.apache.kafka.common.requests.ListGroupsResponse;
import org.apache.kafka.common.requests.ListMirrorsResponse;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.common.requests.ListPartitionReassignmentsResponse;
import org.apache.kafka.common.requests.ListTransactionsResponse;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.requests.OffsetDeleteResponse;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.PublishQuotaTargetResponse;
import org.apache.kafka.common.requests.PushTelemetryResponse;
import org.apache.kafka.common.requests.ReadShareGroupStateResponse;
import org.apache.kafka.common.requests.ReadShareGroupStateSummaryResponse;
import org.apache.kafka.common.requests.RemoveBrokersResponse;
import org.apache.kafka.common.requests.RemoveRaftVoterResponse;
import org.apache.kafka.common.requests.RenewDelegationTokenResponse;
import org.apache.kafka.common.requests.ReplicaStatusResponse;
import org.apache.kafka.common.requests.ReportClusterLinkStatusResponse;
import org.apache.kafka.common.requests.ReportQuotaConsumptionResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.common.requests.ResolveOffsetRangeResponse;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.kafka.common.requests.ReverseConnectionResponse;
import org.apache.kafka.common.requests.SaslAuthenticateResponse;
import org.apache.kafka.common.requests.SaslHandshakeResponse;
import org.apache.kafka.common.requests.ShareAcknowledgeResponse;
import org.apache.kafka.common.requests.ShareFetchResponse;
import org.apache.kafka.common.requests.ShareGroupDescribeResponse;
import org.apache.kafka.common.requests.ShareGroupHeartbeatResponse;
import org.apache.kafka.common.requests.StreamsGroupDescribeResponse;
import org.apache.kafka.common.requests.StreamsGroupHeartbeatResponse;
import org.apache.kafka.common.requests.SyncGroupResponse;
import org.apache.kafka.common.requests.TriggerEvenClusterLoadResponse;
import org.apache.kafka.common.requests.TxnOffsetCommitResponse;
import org.apache.kafka.common.requests.UnAssignBrokersFromCellResponse;
import org.apache.kafka.common.requests.UnregisterBrokerResponse;
import org.apache.kafka.common.requests.UpdateFeaturesResponse;
import org.apache.kafka.common.requests.UpdateRaftVoterResponse;
import org.apache.kafka.common.requests.VoteResponse;
import org.apache.kafka.common.requests.WriteShareGroupStateResponse;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;

public abstract class AbstractResponse
implements AbstractRequestResponse {
    public static final int DEFAULT_THROTTLE_TIME = 0;
    private final ApiKeys apiKey;

    protected AbstractResponse(ApiKeys apiKey) {
        this.apiKey = apiKey;
    }

    public final Send toSend(ResponseHeader header, short version) {
        return SendBuilder.buildResponseSend(header, this.data(), version);
    }

    public final Send toSend(ResponseHeader header, short version, MessageContext context) {
        return SendBuilder.buildResponseSend(header, this.data(), version, context);
    }

    final ByteBuffer serializeWithHeader(ResponseHeader header, short version) {
        return RequestUtils.serialize(header.data(), header.headerVersion(), this.data(), version);
    }

    final ByteBufferAccessor serialize(short version) {
        return MessageUtil.toByteBufferAccessor(this.data(), version);
    }

    public abstract Map<Errors, Integer> errorCounts();

    protected static Map<Errors, Integer> errorCounts(Errors error) {
        return Collections.singletonMap(error, 1);
    }

    protected static Map<Errors, Integer> errorCounts(Stream<Errors> errors) {
        return errors.collect(Collectors.groupingBy(e -> e, Collectors.summingInt(e -> 1)));
    }

    protected static Map<Errors, Integer> errorCounts(Collection<Errors> errors) {
        EnumMap<Errors, Integer> errorCounts = new EnumMap<Errors, Integer>(Errors.class);
        for (Errors error : errors) {
            AbstractResponse.updateErrorCounts(errorCounts, error);
        }
        return errorCounts;
    }

    protected static Map<Errors, Integer> apiErrorCounts(Map<?, ApiError> errors) {
        EnumMap<Errors, Integer> errorCounts = new EnumMap<Errors, Integer>(Errors.class);
        for (ApiError apiError : errors.values()) {
            AbstractResponse.updateErrorCounts(errorCounts, apiError.error());
        }
        return errorCounts;
    }

    protected static void updateErrorCounts(Map<Errors, Integer> errorCounts, Errors error) {
        Integer count = errorCounts.getOrDefault((Object)error, 0);
        errorCounts.put(error, count + 1);
    }

    public static AbstractResponse parseResponse(ByteBuffer buffer, RequestHeader requestHeader, MessageContext context) {
        ApiKeys apiKey = requestHeader.apiKey();
        short apiVersion = requestHeader.apiVersion();
        ResponseHeader responseHeader = ResponseHeader.parse(buffer, apiKey.responseHeaderVersion(apiVersion));
        if (requestHeader.correlationId() != responseHeader.correlationId()) {
            throw new CorrelationIdMismatchException("Correlation id for response (" + responseHeader.correlationId() + ") does not match request (" + requestHeader.correlationId() + "), request header: " + String.valueOf(requestHeader), requestHeader.correlationId(), responseHeader.correlationId());
        }
        return AbstractResponse.parseResponse(apiKey, new ByteBufferAccessor(buffer), apiVersion, context);
    }

    public static AbstractResponse parseResponse(ApiKeys apiKey, Readable readable, short version, MessageContext context) {
        switch (apiKey) {
            case PRODUCE: {
                return ProduceResponse.parse(readable, version, context);
            }
            case FETCH: {
                return FetchResponse.parse(readable, version, context);
            }
            case LIST_OFFSETS: {
                return ListOffsetsResponse.parse(readable, version, context);
            }
            case METADATA: {
                return MetadataResponse.parse(readable, version, context);
            }
            case OFFSET_COMMIT: {
                return OffsetCommitResponse.parse(readable, version, context);
            }
            case OFFSET_FETCH: {
                return OffsetFetchResponse.parse(readable, version, context);
            }
            case FIND_COORDINATOR: {
                return FindCoordinatorResponse.parse(readable, version, context);
            }
            case JOIN_GROUP: {
                return JoinGroupResponse.parse(readable, version, context);
            }
            case HEARTBEAT: {
                return HeartbeatResponse.parse(readable, version, context);
            }
            case LEAVE_GROUP: {
                return LeaveGroupResponse.parse(readable, version, context);
            }
            case SYNC_GROUP: {
                return SyncGroupResponse.parse(readable, version, context);
            }
            case DESCRIBE_GROUPS: {
                return DescribeGroupsResponse.parse(readable, version, context);
            }
            case LIST_GROUPS: {
                return ListGroupsResponse.parse(readable, version, context);
            }
            case SASL_HANDSHAKE: {
                return SaslHandshakeResponse.parse(readable, version, context);
            }
            case API_VERSIONS: {
                return ApiVersionsResponse.parse(readable, version, context);
            }
            case CREATE_TOPICS: {
                return CreateTopicsResponse.parse(readable, version, context);
            }
            case DELETE_TOPICS: {
                return DeleteTopicsResponse.parse(readable, version, context);
            }
            case DELETE_RECORDS: {
                return DeleteRecordsResponse.parse(readable, version, context);
            }
            case INIT_PRODUCER_ID: {
                return InitProducerIdResponse.parse(readable, version, context);
            }
            case OFFSET_FOR_LEADER_EPOCH: {
                return OffsetsForLeaderEpochResponse.parse(readable, version, context);
            }
            case ADD_PARTITIONS_TO_TXN: {
                return AddPartitionsToTxnResponse.parse(readable, version, context);
            }
            case ADD_OFFSETS_TO_TXN: {
                return AddOffsetsToTxnResponse.parse(readable, version, context);
            }
            case END_TXN: {
                return EndTxnResponse.parse(readable, version, context);
            }
            case WRITE_TXN_MARKERS: {
                return WriteTxnMarkersResponse.parse(readable, version, context);
            }
            case TXN_OFFSET_COMMIT: {
                return TxnOffsetCommitResponse.parse(readable, version, context);
            }
            case DESCRIBE_ACLS: {
                return DescribeAclsResponse.parse(readable, version, context);
            }
            case CREATE_ACLS: {
                return CreateAclsResponse.parse(readable, version, context);
            }
            case DELETE_ACLS: {
                return DeleteAclsResponse.parse(readable, version, context);
            }
            case DESCRIBE_CONFIGS: {
                return DescribeConfigsResponse.parse(readable, version, context);
            }
            case ALTER_CONFIGS: {
                return AlterConfigsResponse.parse(readable, version, context);
            }
            case ALTER_REPLICA_LOG_DIRS: {
                return AlterReplicaLogDirsResponse.parse(readable, version, context);
            }
            case DESCRIBE_LOG_DIRS: {
                return DescribeLogDirsResponse.parse(readable, version, context);
            }
            case SASL_AUTHENTICATE: {
                return SaslAuthenticateResponse.parse(readable, version, context);
            }
            case CREATE_PARTITIONS: {
                return CreatePartitionsResponse.parse(readable, version, context);
            }
            case CREATE_DELEGATION_TOKEN: {
                return CreateDelegationTokenResponse.parse(readable, version, context);
            }
            case RENEW_DELEGATION_TOKEN: {
                return RenewDelegationTokenResponse.parse(readable, version, context);
            }
            case EXPIRE_DELEGATION_TOKEN: {
                return ExpireDelegationTokenResponse.parse(readable, version, context);
            }
            case DESCRIBE_DELEGATION_TOKEN: {
                return DescribeDelegationTokenResponse.parse(readable, version, context);
            }
            case DELETE_GROUPS: {
                return DeleteGroupsResponse.parse(readable, version, context);
            }
            case ELECT_LEADERS: {
                return ElectLeadersResponse.parse(readable, version, context);
            }
            case INCREMENTAL_ALTER_CONFIGS: {
                return IncrementalAlterConfigsResponse.parse(readable, version, context);
            }
            case ALTER_PARTITION_REASSIGNMENTS: {
                return AlterPartitionReassignmentsResponse.parse(readable, version, context);
            }
            case LIST_PARTITION_REASSIGNMENTS: {
                return ListPartitionReassignmentsResponse.parse(readable, version, context);
            }
            case OFFSET_DELETE: {
                return OffsetDeleteResponse.parse(readable, version, context);
            }
            case DESCRIBE_CLIENT_QUOTAS: {
                return DescribeClientQuotasResponse.parse(readable, version, context);
            }
            case ALTER_CLIENT_QUOTAS: {
                return AlterClientQuotasResponse.parse(readable, version, context);
            }
            case DESCRIBE_USER_SCRAM_CREDENTIALS: {
                return DescribeUserScramCredentialsResponse.parse(readable, version, context);
            }
            case ALTER_USER_SCRAM_CREDENTIALS: {
                return AlterUserScramCredentialsResponse.parse(readable, version, context);
            }
            case VOTE: {
                return VoteResponse.parse(readable, version, context);
            }
            case BEGIN_QUORUM_EPOCH: {
                return BeginQuorumEpochResponse.parse(readable, version, context);
            }
            case END_QUORUM_EPOCH: {
                return EndQuorumEpochResponse.parse(readable, version, context);
            }
            case DESCRIBE_QUORUM: {
                return DescribeQuorumResponse.parse(readable, version, context);
            }
            case ALTER_PARTITION: {
                return AlterPartitionResponse.parse(readable, version, context);
            }
            case UPDATE_FEATURES: {
                return UpdateFeaturesResponse.parse(readable, version, context);
            }
            case ENVELOPE: {
                return EnvelopeResponse.parse(readable, version, context);
            }
            case FETCH_SNAPSHOT: {
                return FetchSnapshotResponse.parse(readable, version, context);
            }
            case DESCRIBE_CLUSTER: {
                return DescribeClusterResponse.parse(readable, version, context);
            }
            case DESCRIBE_PRODUCERS: {
                return DescribeProducersResponse.parse(readable, version, context);
            }
            case BROKER_REGISTRATION: {
                return BrokerRegistrationResponse.parse(readable, version, context);
            }
            case BROKER_HEARTBEAT: {
                return BrokerHeartbeatResponse.parse(readable, version, context);
            }
            case UNREGISTER_BROKER: {
                return UnregisterBrokerResponse.parse(readable, version, context);
            }
            case DESCRIBE_TRANSACTIONS: {
                return DescribeTransactionsResponse.parse(readable, version, context);
            }
            case LIST_TRANSACTIONS: {
                return ListTransactionsResponse.parse(readable, version, context);
            }
            case ALLOCATE_PRODUCER_IDS: {
                return AllocateProducerIdsResponse.parse(readable, version, context);
            }
            case CONSUMER_GROUP_HEARTBEAT: {
                return ConsumerGroupHeartbeatResponse.parse(readable, version, context);
            }
            case CONSUMER_GROUP_DESCRIBE: {
                return ConsumerGroupDescribeResponse.parse(readable, version, context);
            }
            case CONTROLLER_REGISTRATION: {
                return ControllerRegistrationResponse.parse(readable, version, context);
            }
            case GET_TELEMETRY_SUBSCRIPTIONS: {
                return GetTelemetrySubscriptionsResponse.parse(readable, version, context);
            }
            case PUSH_TELEMETRY: {
                return PushTelemetryResponse.parse(readable, version, context);
            }
            case ASSIGN_REPLICAS_TO_DIRS: {
                return AssignReplicasToDirsResponse.parse(readable, version, context);
            }
            case LIST_CONFIG_RESOURCES: {
                return ListConfigResourcesResponse.parse(readable, version, context);
            }
            case DESCRIBE_TOPIC_PARTITIONS: {
                return DescribeTopicPartitionsResponse.parse(readable, version, context);
            }
            case SHARE_GROUP_HEARTBEAT: {
                return ShareGroupHeartbeatResponse.parse(readable, version, context);
            }
            case SHARE_GROUP_DESCRIBE: {
                return ShareGroupDescribeResponse.parse(readable, version, context);
            }
            case SHARE_FETCH: {
                return ShareFetchResponse.parse(readable, version, context);
            }
            case SHARE_ACKNOWLEDGE: {
                return ShareAcknowledgeResponse.parse(readable, version, context);
            }
            case ADD_RAFT_VOTER: {
                return AddRaftVoterResponse.parse(readable, version, context);
            }
            case REMOVE_RAFT_VOTER: {
                return RemoveRaftVoterResponse.parse(readable, version, context);
            }
            case UPDATE_RAFT_VOTER: {
                return UpdateRaftVoterResponse.parse(readable, version, context);
            }
            case INITIALIZE_SHARE_GROUP_STATE: {
                return InitializeShareGroupStateResponse.parse(readable, version, context);
            }
            case READ_SHARE_GROUP_STATE: {
                return ReadShareGroupStateResponse.parse(readable, version, context);
            }
            case WRITE_SHARE_GROUP_STATE: {
                return WriteShareGroupStateResponse.parse(readable, version, context);
            }
            case DELETE_SHARE_GROUP_STATE: {
                return DeleteShareGroupStateResponse.parse(readable, version, context);
            }
            case READ_SHARE_GROUP_STATE_SUMMARY: {
                return ReadShareGroupStateSummaryResponse.parse(readable, version, context);
            }
            case STREAMS_GROUP_HEARTBEAT: {
                return StreamsGroupHeartbeatResponse.parse(readable, version, context);
            }
            case STREAMS_GROUP_DESCRIBE: {
                return StreamsGroupDescribeResponse.parse(readable, version, context);
            }
            case DESCRIBE_SHARE_GROUP_OFFSETS: {
                return DescribeShareGroupOffsetsResponse.parse(readable, version, context);
            }
            case ALTER_SHARE_GROUP_OFFSETS: {
                return AlterShareGroupOffsetsResponse.parse(readable, version, context);
            }
            case DELETE_SHARE_GROUP_OFFSETS: {
                return DeleteShareGroupOffsetsResponse.parse(readable, version, context);
            }
        }
        return AbstractResponse.maybeParseInternalResponse(apiKey, readable, version, context);
    }

    public static AbstractResponse maybeParseInternalResponse(ApiKeys apiKey, Readable readable, short version, MessageContext context) {
        switch (apiKey) {
            case REMOVE_BROKERS: {
                return RemoveBrokersResponse.parse(readable, version, context);
            }
            case INITIATE_SHUTDOWN: {
                return InitiateShutdownResponse.parse(readable, version, context);
            }
            case DESCRIBE_BROKER_REMOVALS: {
                return DescribeBrokerRemovalsResponse.parse(readable, version, context);
            }
            case DESCRIBE_BROKER_ADDITIONS: {
                return DescribeBrokerAdditionsResponse.parse(readable, version, context);
            }
            case DESCRIBE_BALANCER_STATUS: {
                return DescribeBalancerStatusResponse.parse(readable, version, context);
            }
            case REPLICA_STATUS: {
                return ReplicaStatusResponse.parse(readable, version, context);
            }
            case CREATE_CLUSTER_LINKS: {
                return CreateClusterLinksResponse.parse(readable, version, context);
            }
            case LIST_CLUSTER_LINKS: {
                return ListClusterLinksResponse.parse(readable, version, context);
            }
            case DESCRIBE_CLUSTER_LINKS: {
                return DescribeClusterLinksResponse.parse(readable, version, context);
            }
            case REPORT_CLUSTER_LINK_STATUS: {
                return ReportClusterLinkStatusResponse.parse(readable, version, context);
            }
            case DELETE_CLUSTER_LINKS: {
                return DeleteClusterLinksResponse.parse(readable, version, context);
            }
            case ALTER_MIRRORS: {
                return AlterMirrorsResponse.parse(readable, version, context);
            }
            case LIST_MIRRORS: {
                return ListMirrorsResponse.parse(readable, version, context);
            }
            case DESCRIBE_MIRRORS: {
                return DescribeMirrorsResponse.parse(readable, version, context);
            }
            case DESCRIBE_SWITCHOVER_STATUS: {
                return DescribeSwitchoverStatusResponse.parse(readable, version, context);
            }
            case DESCRIBE_EVEN_CLUSTER_LOAD_STATUS: {
                return DescribeEvenClusterLoadStatusResponse.parse(readable, version, context);
            }
            case INITIATE_REVERSE_CONNECTIONS: {
                return InitiateReverseConnectionsResponse.parse(readable, version, context);
            }
            case REVERSE_CONNECTION: {
                return ReverseConnectionResponse.parse(readable, version, context);
            }
            case ALTER_BROKER_HEALTH: {
                return AlterBrokerHealthResponse.parse(readable, version, context);
            }
            case DESCRIBE_BROKER_HEALTH: {
                return DescribeBrokerHealthResponse.parse(readable, version, context);
            }
            case ALTER_BROKER_REPLICA_EXCLUSIONS: {
                return AlterBrokerReplicaExclusionsResponse.parse(readable, version, context);
            }
            case DESCRIBE_BROKER_REPLICA_EXCLUSIONS: {
                return DescribeBrokerReplicaExclusionsResponse.parse(readable, version, context);
            }
            case REPORT_QUOTA_CONSUMPTION: {
                return ReportQuotaConsumptionResponse.parse(readable, version, context);
            }
            case PUBLISH_QUOTA_TARGET: {
                return PublishQuotaTargetResponse.parse(readable, version, context);
            }
            case TRIGGER_EVEN_CLUSTER_LOAD: {
                return TriggerEvenClusterLoadResponse.parse(readable, version, context);
            }
            case COMPUTE_EVEN_CLUSTER_LOAD_PLAN: {
                return ComputeEvenClusterLoadPlanResponse.parse(readable, version, context);
            }
            case ALTER_MIRROR_TOPICS: {
                return AlterMirrorTopicsResponse.parse(readable, version, context);
            }
            case CREATE_CELL: {
                return CreateCellResponse.parse(readable, version, context);
            }
            case DRAIN_CELL: {
                return DrainCellResponse.parse(readable, version, context);
            }
            case DELETE_CELL: {
                return DeleteCellResponse.parse(readable, version, context);
            }
            case ALTER_CELL: {
                return AlterCellResponse.parse(readable, version, context);
            }
            case DESCRIBE_CELLS: {
                return DescribeCellsResponse.parse(readable, version, context);
            }
            case DESCRIBE_TENANTS: {
                return DescribeTenantsResponse.parse(readable, version, context);
            }
            case ASSIGN_TENANTS_TO_CELL: {
                return AssignTenantsToCellResponse.parse(readable, version, context);
            }
            case ASSIGN_BROKERS_TO_CELL: {
                return AssignBrokersToCellResponse.parse(readable, version, context);
            }
            case UN_ASSIGN_BROKERS_FROM_CELL: {
                return UnAssignBrokersFromCellResponse.parse(readable, version, context);
            }
            case DELETE_TENANTS: {
                return DeleteTenantsResponse.parse(readable, version, context);
            }
            case DESCRIBE_CELL_LOAD: {
                return DescribeCellLoadResponse.parse(readable, version, context);
            }
            case DESCRIBE_NETWORK: {
                return DescribeNetworkResponse.parse(readable, version, context);
            }
            case APPEND_RECORDS: {
                return AppendRecordsResponse.parse(readable, version, context);
            }
            case ALTER_CELL_MIGRATION: {
                return AlterCellMigrationResponse.parse(readable, version, context);
            }
            case DESCRIBE_CELL_MIGRATION: {
                return DescribeCellMigrationResponse.parse(readable, version, context);
            }
            case RESOLVE_OFFSET_RANGE: {
                return ResolveOffsetRangeResponse.parse(readable, version, context);
            }
            case ALTER_CLUSTER_LINKS: {
                return AlterClusterLinksResponse.parse(readable, version, context);
            }
        }
        throw new AssertionError((Object)String.format("ApiKey %s is not currently handled in `parseResponse`, the code should be updated to do so.", new Object[]{apiKey}));
    }

    public boolean shouldClientThrottle(short version) {
        return false;
    }

    public ApiKeys apiKey() {
        return this.apiKey;
    }

    public abstract int throttleTimeMs();

    public abstract void maybeSetThrottleTimeMs(int var1);

    public String toString() {
        return this.data().toString();
    }
}

