/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.handler.codec.http2.Http2Headers;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;

public class K2PStreamMetadata {
    private static final String HEADER_FIELD_PREFIX = "x-k2p-";
    public static final String PRINCIPAL_HEADER = "x-k2p-principal";
    public static final String TENANT_HEADER = "x-k2p-tenant";
    public static final String CLIENT_AUTHED = "x-k2p-client-authed";
    public static final String CLIENT_ADDR = "x-k2p-client-addr";
    public static final String CLIENT_PORT = "x-k2p-client-port";
    public static final String CLIENT_SOFTWARE_NAME = "x-k2p-client-software-name";
    public static final String CLIENT_SOFTWARE_VERSION = "x-k2p-client-software-version";
    public static final String CLIENT_ID = "x-k2p-client-id";
    public static final Charset DEFAULT_CHARSET = StandardCharsets.ISO_8859_1;
    private final Optional<KafkaPrincipalSerde> principalSerde;
    private final KafkaPrincipal principal;
    private final boolean clientAuthenticated;
    private final String tenant;
    private final String clientAddress;
    private final Integer clientPort;
    private final String clientSoftwareName;
    private final String clientSoftwareVersion;
    private final String clientId;

    public K2PStreamMetadata(Optional<KafkaPrincipalSerde> principalSerde, KafkaPrincipal principal, boolean clientAuthenticated, String tenant, String clientAddress, Integer clientPort, String clientSoftwareName, String clientSoftwareVersion, String clientId) {
        this.principalSerde = principalSerde;
        this.principal = principal;
        this.clientAuthenticated = clientAuthenticated;
        this.tenant = tenant;
        this.clientAddress = clientAddress;
        this.clientPort = clientPort;
        this.clientSoftwareName = clientSoftwareName;
        this.clientSoftwareVersion = clientSoftwareVersion;
        this.clientId = clientId;
    }

    public K2PStreamMetadata(Http2Headers http2Headers, Optional<KafkaPrincipalSerde> principalSerde) {
        this.principalSerde = principalSerde;
        this.principal = K2PStreamMetadata.base64DecodeKafkaPrincipal((CharSequence)http2Headers.get((Object)PRINCIPAL_HEADER), principalSerde);
        this.clientAuthenticated = http2Headers.getBoolean((Object)CLIENT_AUTHED, false);
        this.tenant = K2PStreamMetadata.base64Decode((CharSequence)http2Headers.get((Object)TENANT_HEADER));
        this.clientAddress = K2PStreamMetadata.base64Decode((CharSequence)http2Headers.get((Object)CLIENT_ADDR));
        this.clientPort = http2Headers.getInt((Object)CLIENT_PORT);
        this.clientSoftwareName = K2PStreamMetadata.base64Decode((CharSequence)http2Headers.get((Object)CLIENT_SOFTWARE_NAME));
        this.clientSoftwareVersion = K2PStreamMetadata.base64Decode((CharSequence)http2Headers.get((Object)CLIENT_SOFTWARE_VERSION));
        this.clientId = K2PStreamMetadata.base64Decode((CharSequence)http2Headers.get((Object)CLIENT_ID));
    }

    public void serialize(Http2Headers http2Headers) {
        String principalHeader = K2PStreamMetadata.base64EncodeKafkaPrincipal(this.principal, this.principalSerde);
        if (principalHeader != null) {
            http2Headers.set((Object)PRINCIPAL_HEADER, (Object)principalHeader);
        }
        http2Headers.setBoolean((Object)CLIENT_AUTHED, this.clientAuthenticated);
        if (this.tenant != null) {
            http2Headers.set((Object)TENANT_HEADER, (Object)K2PStreamMetadata.base64Encode(this.tenant));
        }
        if (this.clientAddress != null) {
            http2Headers.set((Object)CLIENT_ADDR, (Object)K2PStreamMetadata.base64Encode(this.clientAddress));
        }
        if (this.clientPort != null) {
            http2Headers.setInt((Object)CLIENT_PORT, this.clientPort.intValue());
        }
        if (this.clientSoftwareName != null) {
            http2Headers.set((Object)CLIENT_SOFTWARE_NAME, (Object)K2PStreamMetadata.base64Encode(this.clientSoftwareName));
        }
        if (this.clientSoftwareVersion != null) {
            http2Headers.set((Object)CLIENT_SOFTWARE_VERSION, (Object)K2PStreamMetadata.base64Encode(this.clientSoftwareVersion));
        }
        if (this.clientId != null) {
            http2Headers.set((Object)CLIENT_ID, (Object)K2PStreamMetadata.base64Encode(this.clientId));
        }
    }

    public KafkaPrincipal principal() {
        return this.principal;
    }

    public String tenant() {
        return this.tenant;
    }

    public boolean clientAuthenticated() {
        return this.clientAuthenticated;
    }

    public String clientAddress() {
        return this.clientAddress;
    }

    public Integer clientPort() {
        return this.clientPort;
    }

    public ClientInformation clientInformation() {
        return new ClientInformation(this.clientSoftwareName == null ? "unknown" : this.clientSoftwareName, this.clientSoftwareVersion == null ? "unknown" : this.clientSoftwareVersion);
    }

    public String clientId() {
        return this.clientId;
    }

    static CharSequence base64Encode(String value) {
        return new String(Base64.getUrlEncoder().encode(value.getBytes(DEFAULT_CHARSET)), DEFAULT_CHARSET);
    }

    static String base64Decode(CharSequence value) {
        if (value == null) {
            return null;
        }
        return new String(Base64.getUrlDecoder().decode(K2PStreamMetadata.charSequenceToBytes(value)), DEFAULT_CHARSET);
    }

    static byte[] charSequenceToBytes(CharSequence value) {
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        return value.toString().getBytes(DEFAULT_CHARSET);
    }

    static String base64EncodeKafkaPrincipal(KafkaPrincipal principal, Optional<KafkaPrincipalSerde> kafkaPrincipalSerde) {
        if (principal == null) {
            return null;
        }
        if (kafkaPrincipalSerde.isEmpty()) {
            return null;
        }
        byte[] data = kafkaPrincipalSerde.get().serialize(principal);
        return new String(Base64.getUrlEncoder().encode(data), DEFAULT_CHARSET);
    }

    static KafkaPrincipal base64DecodeKafkaPrincipal(CharSequence principalHeader, Optional<KafkaPrincipalSerde> kafkaPrincipalSerde) {
        if (principalHeader == null) {
            return null;
        }
        if (kafkaPrincipalSerde.isEmpty()) {
            return null;
        }
        byte[] data = Base64.getUrlDecoder().decode(K2PStreamMetadata.charSequenceToBytes(principalHeader));
        return kafkaPrincipalSerde.get().deserialize(data);
    }
}

