/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ReportClusterLinkStatusRequestData
implements ApiMessage {
    int brokerId;
    int timeoutMs;
    List<LinkMirrorState> linkMirrorStates;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("broker_id", Type.INT32, "The unique id of the broker."), new Field("timeout_ms", Type.INT32, "The time, in milliseconds, to allow for request completion."), new Field("link_mirror_states", new CompactArrayOf(LinkMirrorState.SCHEMA_0), "Mirror States for all partitions in the link."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public ReportClusterLinkStatusRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public ReportClusterLinkStatusRequestData() {
        this.brokerId = 0;
        this.timeoutMs = 0;
        this.linkMirrorStates = new ArrayList<LinkMirrorState>(0);
    }

    @Override
    public short apiKey() {
        return 10040;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        this.brokerId = _readable.readInt();
        this.timeoutMs = _readable.readInt();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field linkMirrorStates was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<LinkMirrorState> newCollection = new ArrayList<LinkMirrorState>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new LinkMirrorState(_readable, _version, _context));
        }
        this.linkMirrorStates = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.brokerId);
        _writable.writeInt(this.timeoutMs);
        _writable.writeUnsignedVarint(this.linkMirrorStates.size() + 1);
        for (LinkMirrorState linkMirrorStatesElement : this.linkMirrorStates) {
            linkMirrorStatesElement.write(_writable, _cache, _version, _context);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(4);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.linkMirrorStates.size() + 1));
        for (LinkMirrorState linkMirrorStatesElement : this.linkMirrorStates) {
            linkMirrorStatesElement.addSize(_size, _cache, _version, _context);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ReportClusterLinkStatusRequestData)) {
            return false;
        }
        ReportClusterLinkStatusRequestData other = (ReportClusterLinkStatusRequestData)obj;
        if (this.brokerId != other.brokerId) {
            return false;
        }
        if (this.timeoutMs != other.timeoutMs) {
            return false;
        }
        if (this.linkMirrorStates == null ? other.linkMirrorStates != null : !this.linkMirrorStates.equals(other.linkMirrorStates)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.brokerId;
        hashCode = 31 * hashCode + this.timeoutMs;
        hashCode = 31 * hashCode + (this.linkMirrorStates == null ? 0 : this.linkMirrorStates.hashCode());
        return hashCode;
    }

    @Override
    public ReportClusterLinkStatusRequestData duplicate() {
        ReportClusterLinkStatusRequestData _duplicate = new ReportClusterLinkStatusRequestData();
        _duplicate.brokerId = this.brokerId;
        _duplicate.timeoutMs = this.timeoutMs;
        ArrayList<LinkMirrorState> newLinkMirrorStates = new ArrayList<LinkMirrorState>(this.linkMirrorStates.size());
        for (LinkMirrorState _element : this.linkMirrorStates) {
            newLinkMirrorStates.add(_element.duplicate());
        }
        _duplicate.linkMirrorStates = newLinkMirrorStates;
        return _duplicate;
    }

    public String toString() {
        return "ReportClusterLinkStatusRequestData(brokerId=" + this.brokerId + ", timeoutMs=" + this.timeoutMs + ", linkMirrorStates=" + MessageUtil.deepToString(this.linkMirrorStates.iterator()) + ")";
    }

    public int brokerId() {
        return this.brokerId;
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    public List<LinkMirrorState> linkMirrorStates() {
        return this.linkMirrorStates;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ReportClusterLinkStatusRequestData setBrokerId(int v) {
        this.brokerId = v;
        return this;
    }

    public ReportClusterLinkStatusRequestData setTimeoutMs(int v) {
        this.timeoutMs = v;
        return this;
    }

    public ReportClusterLinkStatusRequestData setLinkMirrorStates(List<LinkMirrorState> v) {
        this.linkMirrorStates = v;
        return this;
    }

    public static class LinkMirrorState
    implements Message {
        String linkName;
        List<MirrorState> mirrorStates;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("link_name", Type.COMPACT_STRING, "Unique name for cluster link."), new Field("mirror_states", new CompactArrayOf(MirrorState.SCHEMA_0), "Mirror States for partition."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public LinkMirrorState(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public LinkMirrorState() {
            this.linkName = "";
            this.mirrorStates = new ArrayList<MirrorState>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of LinkMirrorState");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field linkName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field linkName had invalid length " + length);
            }
            this.linkName = _readable.readString(length);
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field mirrorStates was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<MirrorState> newCollection = new ArrayList<MirrorState>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new MirrorState(_readable, _version, _context));
            }
            this.mirrorStates = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.linkName);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeUnsignedVarint(this.mirrorStates.size() + 1);
            _stringBytes = this.mirrorStates.iterator();
            while (_stringBytes.hasNext()) {
                MirrorState mirrorStatesElement = (MirrorState)_stringBytes.next();
                mirrorStatesElement.write(_writable, _cache, _version, _context);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of LinkMirrorState");
            }
            byte[] _stringBytes = this.linkName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'linkName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.linkName, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.mirrorStates.size() + 1));
            for (MirrorState mirrorStatesElement : this.mirrorStates) {
                mirrorStatesElement.addSize(_size, _cache, _version, _context);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LinkMirrorState)) {
                return false;
            }
            LinkMirrorState other = (LinkMirrorState)obj;
            if (this.linkName == null ? other.linkName != null : !this.linkName.equals(other.linkName)) {
                return false;
            }
            if (this.mirrorStates == null ? other.mirrorStates != null : !this.mirrorStates.equals(other.mirrorStates)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.linkName == null ? 0 : this.linkName.hashCode());
            hashCode = 31 * hashCode + (this.mirrorStates == null ? 0 : this.mirrorStates.hashCode());
            return hashCode;
        }

        @Override
        public LinkMirrorState duplicate() {
            LinkMirrorState _duplicate = new LinkMirrorState();
            _duplicate.linkName = this.linkName;
            ArrayList<MirrorState> newMirrorStates = new ArrayList<MirrorState>(this.mirrorStates.size());
            for (MirrorState _element : this.mirrorStates) {
                newMirrorStates.add(_element.duplicate());
            }
            _duplicate.mirrorStates = newMirrorStates;
            return _duplicate;
        }

        public String toString() {
            return "LinkMirrorState(linkName=" + (String)(this.linkName == null ? "null" : "'" + this.linkName.toString() + "'") + ", mirrorStates=" + MessageUtil.deepToString(this.mirrorStates.iterator()) + ")";
        }

        public String linkName() {
            return this.linkName;
        }

        public List<MirrorState> mirrorStates() {
            return this.mirrorStates;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public LinkMirrorState setLinkName(String v) {
            this.linkName = v;
            return this;
        }

        public LinkMirrorState setMirrorStates(List<MirrorState> v) {
            this.mirrorStates = v;
            return this;
        }
    }

    public static class MirrorState
    implements Message {
        int partitionId;
        String topicName;
        String mirrorState;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("partition_id", Type.INT32, "Unique id of the partition."), new Field("topic_name", Type.COMPACT_STRING, "Topic name for the partition within the link."), new Field("mirror_state", Type.COMPACT_STRING, "Mirror state for the partition within the link."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public MirrorState(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public MirrorState() {
            this.partitionId = 0;
            this.topicName = "";
            this.mirrorState = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of MirrorState");
            }
            this.partitionId = _readable.readInt();
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field topicName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topicName had invalid length " + length);
            }
            this.topicName = _readable.readString(length);
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field mirrorState was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field mirrorState had invalid length " + length);
            }
            this.mirrorState = _readable.readString(length);
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionId);
            byte[] _stringBytes = _cache.getSerializedValue(this.topicName);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.mirrorState);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of MirrorState");
            }
            _size.addBytes(4);
            byte[] _stringBytes = this.topicName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topicName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topicName, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _stringBytes = this.mirrorState.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'mirrorState' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.mirrorState, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MirrorState)) {
                return false;
            }
            MirrorState other = (MirrorState)obj;
            if (this.partitionId != other.partitionId) {
                return false;
            }
            if (this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName)) {
                return false;
            }
            if (this.mirrorState == null ? other.mirrorState != null : !this.mirrorState.equals(other.mirrorState)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionId;
            hashCode = 31 * hashCode + (this.topicName == null ? 0 : this.topicName.hashCode());
            hashCode = 31 * hashCode + (this.mirrorState == null ? 0 : this.mirrorState.hashCode());
            return hashCode;
        }

        @Override
        public MirrorState duplicate() {
            MirrorState _duplicate = new MirrorState();
            _duplicate.partitionId = this.partitionId;
            _duplicate.topicName = this.topicName;
            _duplicate.mirrorState = this.mirrorState;
            return _duplicate;
        }

        public String toString() {
            return "MirrorState(partitionId=" + this.partitionId + ", topicName=" + (String)(this.topicName == null ? "null" : "'" + this.topicName.toString() + "'") + ", mirrorState=" + (String)(this.mirrorState == null ? "null" : "'" + this.mirrorState.toString() + "'") + ")";
        }

        public int partitionId() {
            return this.partitionId;
        }

        public String topicName() {
            return this.topicName;
        }

        public String mirrorState() {
            return this.mirrorState;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public MirrorState setPartitionId(int v) {
            this.partitionId = v;
            return this;
        }

        public MirrorState setTopicName(String v) {
            this.topicName = v;
            return this;
        }

        public MirrorState setMirrorState(String v) {
            this.mirrorState = v;
            return this;
        }
    }
}

