/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class PushTelemetryRequestData
implements ApiMessage {
    Uuid clientInstanceId;
    int subscriptionId;
    boolean terminating;
    byte compressionType;
    ByteBuffer metrics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("client_instance_id", Type.UUID, "Unique id for this client instance."), new Field("subscription_id", Type.INT32, "Unique identifier for the current subscription."), new Field("terminating", Type.BOOLEAN, "Client is terminating the connection."), new Field("compression_type", Type.INT8, "Compression codec used to compress the metrics."), new Field("metrics", Type.COMPACT_BYTES, "Metrics encoded in OpenTelemetry MetricsData v1 protobuf format."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public PushTelemetryRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public PushTelemetryRequestData() {
        this.clientInstanceId = Uuid.ZERO_UUID;
        this.subscriptionId = 0;
        this.terminating = false;
        this.compressionType = 0;
        this.metrics = ByteUtils.EMPTY_BUF;
    }

    @Override
    public short apiKey() {
        return 72;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        this.clientInstanceId = _readable.readUuid();
        this.subscriptionId = _readable.readInt();
        this.terminating = _readable.readByte() != 0;
        this.compressionType = _readable.readByte();
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field metrics was serialized as null");
        }
        this.metrics = _readable.readByteBuffer(length);
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeUuid(this.clientInstanceId);
        _writable.writeInt(this.subscriptionId);
        _writable.writeByte(this.terminating ? (byte)1 : 0);
        _writable.writeByte(this.compressionType);
        _writable.writeUnsignedVarint(this.metrics.remaining() + 1);
        _writable.writeByteBuffer(this.metrics);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(16);
        _size.addBytes(4);
        _size.addBytes(1);
        _size.addBytes(1);
        _size.addZeroCopyBytes(this.metrics.remaining());
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.metrics.remaining() + 1));
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PushTelemetryRequestData)) {
            return false;
        }
        PushTelemetryRequestData other = (PushTelemetryRequestData)obj;
        if (!this.clientInstanceId.equals(other.clientInstanceId)) {
            return false;
        }
        if (this.subscriptionId != other.subscriptionId) {
            return false;
        }
        if (this.terminating != other.terminating) {
            return false;
        }
        if (this.compressionType != other.compressionType) {
            return false;
        }
        if (!Objects.equals(this.metrics, other.metrics)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.clientInstanceId.hashCode();
        hashCode = 31 * hashCode + this.subscriptionId;
        hashCode = 31 * hashCode + (this.terminating ? 1231 : 1237);
        hashCode = 31 * hashCode + this.compressionType;
        hashCode = 31 * hashCode + Objects.hashCode(this.metrics);
        return hashCode;
    }

    @Override
    public PushTelemetryRequestData duplicate() {
        PushTelemetryRequestData _duplicate = new PushTelemetryRequestData();
        _duplicate.clientInstanceId = this.clientInstanceId;
        _duplicate.subscriptionId = this.subscriptionId;
        _duplicate.terminating = this.terminating;
        _duplicate.compressionType = this.compressionType;
        _duplicate.metrics = this.metrics.duplicate();
        return _duplicate;
    }

    public String toString() {
        return "PushTelemetryRequestData(clientInstanceId=" + this.clientInstanceId.toString() + ", subscriptionId=" + this.subscriptionId + ", terminating=" + (this.terminating ? "true" : "false") + ", compressionType=" + this.compressionType + ", metrics=" + String.valueOf(this.metrics) + ")";
    }

    public Uuid clientInstanceId() {
        return this.clientInstanceId;
    }

    public int subscriptionId() {
        return this.subscriptionId;
    }

    public boolean terminating() {
        return this.terminating;
    }

    public byte compressionType() {
        return this.compressionType;
    }

    public ByteBuffer metrics() {
        return this.metrics;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public PushTelemetryRequestData setClientInstanceId(Uuid v) {
        this.clientInstanceId = v;
        return this;
    }

    public PushTelemetryRequestData setSubscriptionId(int v) {
        this.subscriptionId = v;
        return this;
    }

    public PushTelemetryRequestData setTerminating(boolean v) {
        this.terminating = v;
        return this;
    }

    public PushTelemetryRequestData setCompressionType(byte v) {
        this.compressionType = v;
        return this;
    }

    public PushTelemetryRequestData setMetrics(ByteBuffer v) {
        this.metrics = v;
        return this;
    }
}

