/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.auth.plain;

import io.confluent.kafka.security.auth.plain.DynamicPlainCredential;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.internals.SecurityManagerCompatibility;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicPlainClientCallbackHandler
implements AuthenticateCallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(DynamicPlainClientCallbackHandler.class);

    @Override
    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        log.debug("Configuring SASL/PLAIN client callback handler");
        if (!"PLAIN".equals(saslMechanism)) {
            throw new InvalidConfigurationException("Unexpected configuration with SASL mechanism " + saslMechanism);
        }
        if (jaasConfigEntries.size() != 1) {
            throw new InvalidConfigurationException("Only one JAAS configuration entry supported by this callback handler");
        }
    }

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        Subject subject = SecurityManagerCompatibility.get().current();
        DynamicPlainCredential credential = null;
        try {
            if (subject != null) {
                credential = subject.getPrivateCredentials(DynamicPlainCredential.class).iterator().next();
            }
        }
        catch (NoSuchElementException e) {
            log.debug("No credential found in Subject");
        }
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                NameCallback nc = (NameCallback)callback;
                if (credential != null) {
                    nc.setName(credential.username());
                    continue;
                }
                nc.setName(nc.getDefaultName());
                continue;
            }
            if (callback instanceof PasswordCallback) {
                if (credential != null) {
                    ((PasswordCallback)callback).setPassword(credential.password());
                    continue;
                }
                String errorMessage = "Could not login: the client is being asked for a password, but Kafka clients do not currently support obtaining a password from the user.";
                throw new UnsupportedCallbackException(callback, errorMessage);
            }
            log.error("Unexpected callback {}", (Object)callback);
            throw new UnsupportedCallbackException(callback);
        }
    }

    @Override
    public void close() {
        log.debug("Closing SASL/PLAIN client callback handler");
    }
}

